/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;

public class RobustLineIntersector
extends LineIntersector {
    public void computeIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        this.isProper = false;
        if (Envelope.intersects(coordinate2, coordinate3, coordinate) && RobustCGAlgorithms.orientationIndex(coordinate2, coordinate3, coordinate) == 0 && RobustCGAlgorithms.orientationIndex(coordinate3, coordinate2, coordinate) == 0) {
            this.isProper = true;
            if (coordinate.equals(coordinate2) || coordinate.equals(coordinate3)) {
                this.isProper = false;
            }
            this.result = 1;
            return;
        }
        this.result = 0;
    }

    public int computeIntersect(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        boolean bl;
        this.isProper = false;
        if (!Envelope.intersects(coordinate, coordinate2, coordinate3, coordinate4)) {
            return 0;
        }
        int n = RobustCGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate3);
        int n2 = RobustCGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate4);
        if (n > 0 && n2 > 0 || n < 0 && n2 < 0) {
            return 0;
        }
        int n3 = RobustCGAlgorithms.orientationIndex(coordinate3, coordinate4, coordinate);
        int n4 = RobustCGAlgorithms.orientationIndex(coordinate3, coordinate4, coordinate2);
        if (n3 > 0 && n4 > 0 || n3 < 0 && n4 < 0) {
            return 0;
        }
        boolean bl2 = bl = n == 0 && n2 == 0 && n3 == 0 && n4 == 0;
        if (bl) {
            return this.computeCollinearIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        if (n == 0 || n2 == 0 || n3 == 0 || n4 == 0) {
            this.isProper = false;
            if (n == 0) {
                this.intPt[0] = new Coordinate(coordinate3);
            }
            if (n2 == 0) {
                this.intPt[0] = new Coordinate(coordinate4);
            }
            if (n3 == 0) {
                this.intPt[0] = new Coordinate(coordinate);
            }
            if (n4 == 0) {
                this.intPt[0] = new Coordinate(coordinate2);
            }
        } else {
            this.isProper = true;
            this.intPt[0] = this.intersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        return 1;
    }

    private int computeCollinearIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        boolean bl = Envelope.intersects(coordinate, coordinate2, coordinate3);
        boolean bl2 = Envelope.intersects(coordinate, coordinate2, coordinate4);
        boolean bl3 = Envelope.intersects(coordinate3, coordinate4, coordinate);
        boolean bl4 = Envelope.intersects(coordinate3, coordinate4, coordinate2);
        if (bl && bl2) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate4;
            return 2;
        }
        if (bl3 && bl4) {
            this.intPt[0] = coordinate;
            this.intPt[1] = coordinate2;
            return 2;
        }
        if (bl && bl3) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate;
            return coordinate3.equals(coordinate) && !bl2 && !bl4 ? 1 : 2;
        }
        if (bl && bl4) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate2;
            return coordinate3.equals(coordinate2) && !bl2 && !bl3 ? 1 : 2;
        }
        if (bl2 && bl3) {
            this.intPt[0] = coordinate4;
            this.intPt[1] = coordinate;
            return coordinate4.equals(coordinate) && !bl && !bl4 ? 1 : 2;
        }
        if (bl2 && bl4) {
            this.intPt[0] = coordinate4;
            this.intPt[1] = coordinate2;
            return coordinate4.equals(coordinate2) && !bl && !bl3 ? 1 : 2;
        }
        return 0;
    }

    private Coordinate intersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        Coordinate coordinate5 = new Coordinate(coordinate);
        Coordinate coordinate6 = new Coordinate(coordinate2);
        Coordinate coordinate7 = new Coordinate(coordinate3);
        Coordinate coordinate8 = new Coordinate(coordinate4);
        Coordinate coordinate9 = new Coordinate();
        this.normalize(coordinate5, coordinate6, coordinate7, coordinate8, coordinate9);
        Coordinate coordinate10 = null;
        try {
            coordinate10 = HCoordinate.intersection(coordinate5, coordinate6, coordinate7, coordinate8);
        }
        catch (NotRepresentableException notRepresentableException) {
            Assert.shouldNeverReachHere((String)"Coordinate for intersection is not calculable");
        }
        coordinate10.x += coordinate9.x;
        coordinate10.y += coordinate9.y;
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(coordinate10);
        }
        return coordinate10;
    }

    private void normalize(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, Coordinate coordinate5) {
        coordinate5.x = this.smallestInAbsValue(coordinate.x, coordinate2.x, coordinate3.x, coordinate4.x);
        coordinate5.y = this.smallestInAbsValue(coordinate.y, coordinate2.y, coordinate3.y, coordinate4.y);
        coordinate.x -= coordinate5.x;
        coordinate.y -= coordinate5.y;
        coordinate2.x -= coordinate5.x;
        coordinate2.y -= coordinate5.y;
        coordinate3.x -= coordinate5.x;
        coordinate3.y -= coordinate5.y;
        coordinate4.x -= coordinate5.x;
        coordinate4.y -= coordinate5.y;
    }

    private double smallestInAbsValue(double d, double d2, double d3, double d4) {
        double d5 = d;
        double d6 = Math.abs(d5);
        if (Math.abs(d2) < d6) {
            d5 = d2;
            d6 = Math.abs(d2);
        }
        if (Math.abs(d3) < d6) {
            d5 = d3;
            d6 = Math.abs(d3);
        }
        if (Math.abs(d4) < d6) {
            d5 = d4;
        }
        return d5;
    }

    private boolean isInSegmentEnvelopes(Coordinate coordinate) {
        Envelope envelope = new Envelope(this.inputLines[0][0], this.inputLines[0][1]);
        Envelope envelope2 = new Envelope(this.inputLines[1][0], this.inputLines[1][1]);
        return envelope.contains(coordinate) && envelope2.contains(coordinate);
    }
}

