/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;

public class GeometryFactory {
    private PrecisionModel precisionModel;
    private CoordinateSequenceFactory coordinateSequenceFactory;
    private GeometryEditor editor = new GeometryEditor(this);
    private int SRID;

    public static Point createPointFromInternalCoord(Coordinate coordinate, Geometry geometry) {
        geometry.getPrecisionModel().makePrecise(coordinate);
        return geometry.getFactory().createPoint(coordinate);
    }

    public GeometryFactory(PrecisionModel precisionModel, int n, CoordinateSequenceFactory coordinateSequenceFactory) {
        this.precisionModel = precisionModel;
        this.coordinateSequenceFactory = coordinateSequenceFactory;
        this.SRID = n;
    }

    public GeometryFactory(CoordinateSequenceFactory coordinateSequenceFactory) {
        this(new PrecisionModel(), 0, coordinateSequenceFactory);
    }

    public GeometryFactory(PrecisionModel precisionModel) {
        this(precisionModel, 0, DefaultCoordinateSequenceFactory.instance());
    }

    public GeometryFactory(PrecisionModel precisionModel, int n) {
        this(precisionModel, n, DefaultCoordinateSequenceFactory.instance());
    }

    public GeometryFactory() {
        this(new PrecisionModel(), 0);
    }

    public static Point[] toPointArray(Collection collection) {
        Point[] pointArray = new Point[collection.size()];
        return collection.toArray(pointArray);
    }

    public static Geometry[] toGeometryArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        Geometry[] geometryArray = new Geometry[collection.size()];
        return collection.toArray(geometryArray);
    }

    public static LinearRing[] toLinearRingArray(Collection collection) {
        LinearRing[] linearRingArray = new LinearRing[collection.size()];
        return collection.toArray(linearRingArray);
    }

    public static LineString[] toLineStringArray(Collection collection) {
        LineString[] lineStringArray = new LineString[collection.size()];
        return collection.toArray(lineStringArray);
    }

    public static Polygon[] toPolygonArray(Collection collection) {
        Polygon[] polygonArray = new Polygon[collection.size()];
        return collection.toArray(polygonArray);
    }

    public static MultiPolygon[] toMultiPolygonArray(Collection collection) {
        MultiPolygon[] multiPolygonArray = new MultiPolygon[collection.size()];
        return collection.toArray(multiPolygonArray);
    }

    public static MultiLineString[] toMultiLineStringArray(Collection collection) {
        MultiLineString[] multiLineStringArray = new MultiLineString[collection.size()];
        return collection.toArray(multiLineStringArray);
    }

    public static MultiPoint[] toMultiPointArray(Collection collection) {
        MultiPoint[] multiPointArray = new MultiPoint[collection.size()];
        return collection.toArray(multiPointArray);
    }

    public Geometry toGeometry(Envelope envelope) {
        if (envelope.isNull()) {
            return this.createPoint((CoordinateSequence)null);
        }
        if (envelope.getMinX() == envelope.getMaxX() && envelope.getMinY() == envelope.getMaxY()) {
            return this.createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        return this.createPolygon(this.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public Point createPoint(Coordinate coordinate) {
        return this.createPoint(coordinate != null ? this.getCoordinateSequenceFactory().create(new Coordinate[]{coordinate}) : null);
    }

    public Point createPoint(CoordinateSequence coordinateSequence) {
        return new Point(coordinateSequence, this);
    }

    public MultiLineString createMultiLineString(LineString[] lineStringArray) {
        return new MultiLineString(lineStringArray, this);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometryArray) {
        return new GeometryCollection(geometryArray, this);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygonArray) {
        return new MultiPolygon(polygonArray, this);
    }

    public LinearRing createLinearRing(Coordinate[] coordinateArray) {
        return this.createLinearRing(coordinateArray != null ? this.getCoordinateSequenceFactory().create(coordinateArray) : null);
    }

    public LinearRing createLinearRing(CoordinateSequence coordinateSequence) {
        return new LinearRing(coordinateSequence, this);
    }

    public MultiPoint createMultiPoint(Point[] pointArray) {
        return new MultiPoint(pointArray, this);
    }

    public MultiPoint createMultiPoint(Coordinate[] coordinateArray) {
        return this.createMultiPoint(coordinateArray != null ? this.getCoordinateSequenceFactory().create(coordinateArray) : null);
    }

    public MultiPoint createMultiPoint(CoordinateSequence coordinateSequence) {
        if (coordinateSequence == null) {
            coordinateSequence = this.getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < coordinateSequence.size(); ++i) {
            arrayList.add(this.createPoint(coordinateSequence.getCoordinate(i)));
        }
        return this.createMultiPoint(arrayList.toArray(new Point[0]));
    }

    public Polygon createPolygon(LinearRing linearRing, LinearRing[] linearRingArray) {
        return new Polygon(linearRing, linearRingArray, this);
    }

    public Geometry buildGeometry(Collection collection) {
        boolean bl;
        Class<?> clazz = null;
        boolean bl2 = false;
        Object object = collection.iterator();
        while (object.hasNext()) {
            Geometry geometry = (Geometry)object.next();
            Class<?> clazz2 = geometry.getClass();
            if (clazz == null) {
                clazz = clazz2;
            }
            if (clazz2 == clazz) continue;
            bl2 = true;
        }
        if (clazz == null) {
            return this.createGeometryCollection(null);
        }
        if (bl2) {
            return this.createGeometryCollection(GeometryFactory.toGeometryArray(collection));
        }
        object = (Geometry)collection.iterator().next();
        boolean bl3 = bl = collection.size() > 1;
        if (bl) {
            if (object instanceof Polygon) {
                return this.createMultiPolygon(GeometryFactory.toPolygonArray(collection));
            }
            if (object instanceof LineString) {
                return this.createMultiLineString(GeometryFactory.toLineStringArray(collection));
            }
            if (object instanceof Point) {
                return this.createMultiPoint(GeometryFactory.toPointArray(collection));
            }
            Assert.shouldNeverReachHere();
        }
        return object;
    }

    public LineString createLineString(Coordinate[] coordinateArray) {
        return this.createLineString(coordinateArray != null ? this.getCoordinateSequenceFactory().create(coordinateArray) : null);
    }

    public LineString createLineString(CoordinateSequence coordinateSequence) {
        return new LineString(coordinateSequence, this);
    }

    public Geometry createGeometry(Geometry geometry) {
        return this.editor.edit(geometry, new GeometryEditor.CoordinateOperation(){

            public Coordinate[] edit(Coordinate[] coordinateArray, Geometry geometry) {
                return coordinateArray;
            }
        });
    }

    public int getSRID() {
        return this.SRID;
    }

    public CoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.coordinateSequenceFactory;
    }
}

