/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;

public class LineSegment
implements Comparable,
Serializable {
    public Coordinate p0;
    public Coordinate p1;

    public LineSegment(Coordinate coordinate, Coordinate coordinate2) {
        this.p0 = coordinate;
        this.p1 = coordinate2;
    }

    public LineSegment(LineSegment lineSegment) {
        this(lineSegment.p0, lineSegment.p1);
    }

    public LineSegment() {
        this(new Coordinate(), new Coordinate());
    }

    public Coordinate getCoordinate(int n) {
        if (n == 0) {
            return this.p0;
        }
        return this.p1;
    }

    public void setCoordinates(LineSegment lineSegment) {
        this.setCoordinates(lineSegment.p0, lineSegment.p1);
    }

    public void setCoordinates(Coordinate coordinate, Coordinate coordinate2) {
        this.p0.x = coordinate.x;
        this.p0.y = coordinate.y;
        this.p1.x = coordinate2.x;
        this.p1.y = coordinate2.y;
    }

    public double getLength() {
        return this.p0.distance(this.p1);
    }

    public boolean isHorizontal() {
        return this.p0.y == this.p1.y;
    }

    public boolean isVertical() {
        return this.p0.x == this.p1.x;
    }

    public int orientationIndex(LineSegment lineSegment) {
        int n = RobustCGAlgorithms.orientationIndex(this.p0, this.p1, lineSegment.p0);
        int n2 = RobustCGAlgorithms.orientationIndex(this.p0, this.p1, lineSegment.p1);
        if (n >= 0 && n2 >= 0) {
            return Math.max(n, n2);
        }
        if (n <= 0 && n2 <= 0) {
            return Math.max(n, n2);
        }
        return 0;
    }

    public void reverse() {
        Coordinate coordinate = this.p0;
        this.p0 = this.p1;
        this.p1 = coordinate;
    }

    public void normalize() {
        if (this.p1.compareTo(this.p0) < 0) {
            this.reverse();
        }
    }

    public double angle() {
        return Math.atan2(this.p1.y - this.p0.y, this.p1.x - this.p0.x);
    }

    public double distance(LineSegment lineSegment) {
        return CGAlgorithms.distanceLineLine(this.p0, this.p1, lineSegment.p0, lineSegment.p1);
    }

    public double distance(Coordinate coordinate) {
        return CGAlgorithms.distancePointLine(coordinate, this.p0, this.p1);
    }

    public double distancePerpendicular(Coordinate coordinate) {
        return CGAlgorithms.distancePointLinePerpendicular(coordinate, this.p0, this.p1);
    }

    public double projectionFactor(Coordinate coordinate) {
        if (coordinate.equals(this.p0)) {
            return 0.0;
        }
        if (coordinate.equals(this.p1)) {
            return 1.0;
        }
        double d = this.p1.x - this.p0.x;
        double d2 = this.p1.y - this.p0.y;
        double d3 = d * d + d2 * d2;
        double d4 = ((coordinate.x - this.p0.x) * d + (coordinate.y - this.p0.y) * d2) / d3;
        return d4;
    }

    public Coordinate project(Coordinate coordinate) {
        if (coordinate.equals(this.p0) || coordinate.equals(this.p1)) {
            return new Coordinate(coordinate);
        }
        double d = this.projectionFactor(coordinate);
        Coordinate coordinate2 = new Coordinate();
        coordinate2.x = this.p0.x + d * (this.p1.x - this.p0.x);
        coordinate2.y = this.p0.y + d * (this.p1.y - this.p0.y);
        return coordinate2;
    }

    public LineSegment project(LineSegment lineSegment) {
        double d = this.projectionFactor(lineSegment.p0);
        double d2 = this.projectionFactor(lineSegment.p1);
        if (d >= 1.0 && d2 >= 1.0) {
            return null;
        }
        if (d <= 0.0 && d2 <= 0.0) {
            return null;
        }
        Coordinate coordinate = this.project(lineSegment.p0);
        if (d < 0.0) {
            coordinate = this.p0;
        }
        if (d > 1.0) {
            coordinate = this.p1;
        }
        Coordinate coordinate2 = this.project(lineSegment.p1);
        if (d2 < 0.0) {
            coordinate2 = this.p0;
        }
        if (d2 > 1.0) {
            coordinate2 = this.p1;
        }
        return new LineSegment(coordinate, coordinate2);
    }

    public Coordinate closestPoint(Coordinate coordinate) {
        double d;
        double d2 = this.projectionFactor(coordinate);
        if (d2 > 0.0 && d2 < 1.0) {
            return this.project(coordinate);
        }
        double d3 = this.p0.distance(coordinate);
        if (d3 < (d = this.p1.distance(coordinate))) {
            return this.p0;
        }
        return this.p1;
    }

    public Coordinate[] closestPoints(LineSegment lineSegment) {
        Coordinate coordinate;
        Coordinate coordinate2;
        Coordinate coordinate3 = this.intersection(lineSegment);
        if (coordinate3 != null) {
            return new Coordinate[]{coordinate3, coordinate3};
        }
        Coordinate[] coordinateArray = new Coordinate[2];
        double d = Double.MAX_VALUE;
        Coordinate coordinate4 = this.closestPoint(lineSegment.p0);
        d = coordinate4.distance(lineSegment.p0);
        coordinateArray[0] = coordinate4;
        coordinateArray[1] = lineSegment.p0;
        Coordinate coordinate5 = this.closestPoint(lineSegment.p1);
        double d2 = coordinate5.distance(lineSegment.p1);
        if (d2 < d) {
            d = d2;
            coordinateArray[0] = coordinate5;
            coordinateArray[1] = lineSegment.p1;
        }
        if ((d2 = (coordinate2 = lineSegment.closestPoint(this.p0)).distance(this.p0)) < d) {
            d = d2;
            coordinateArray[0] = this.p0;
            coordinateArray[1] = coordinate2;
        }
        if ((d2 = (coordinate = lineSegment.closestPoint(this.p1)).distance(this.p1)) < d) {
            d = d2;
            coordinateArray[0] = this.p1;
            coordinateArray[1] = coordinate;
        }
        return coordinateArray;
    }

    public Coordinate intersection(LineSegment lineSegment) {
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        robustLineIntersector.computeIntersection(this.p0, this.p1, lineSegment.p0, lineSegment.p1);
        if (robustLineIntersector.hasIntersection()) {
            return robustLineIntersector.getIntersection(0);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineSegment)) {
            return false;
        }
        LineSegment lineSegment = (LineSegment)object;
        return this.p0.equals(lineSegment.p0) && this.p1.equals(lineSegment.p1);
    }

    public int compareTo(Object object) {
        LineSegment lineSegment = (LineSegment)object;
        int n = this.p0.compareTo(lineSegment.p0);
        if (n != 0) {
            return n;
        }
        return this.p1.compareTo(lineSegment.p1);
    }

    public boolean equalsTopo(LineSegment lineSegment) {
        return this.p0.equals(lineSegment.p0) && this.p1.equals(lineSegment.p1) || this.p0.equals(lineSegment.p1) && this.p1.equals(lineSegment.p0);
    }

    public String toString() {
        return "LINESTRING( " + this.p0.x + " " + this.p0.y + ", " + this.p1.x + " " + this.p1.y + ")";
    }
}

