/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.IsSimpleOp;

public class MultiLineString
extends GeometryCollection {
    public MultiLineString(LineString[] lineStringArray, PrecisionModel precisionModel, int n) {
        super(lineStringArray, new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public MultiLineString(LineString[] lineStringArray, GeometryFactory geometryFactory) {
        super(lineStringArray, geometryFactory);
    }

    public int getDimension() {
        return 1;
    }

    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (((LineString)this.geometries[i]).isClosed()) continue;
            return false;
        }
        return true;
    }

    public boolean isSimple() {
        return new IsSimpleOp().isSimple((MultiLineString)this.toInternalGeometry(this));
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createGeometryCollection(null);
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, this.toInternalGeometry(this));
        Coordinate[] coordinateArray = geometryGraph.getBoundaryPoints();
        return this.getFactory().createMultiPoint(coordinateArray);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }
}

