/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;

public class Point
extends Geometry {
    private CoordinateSequence coordinates;

    public Point(Coordinate coordinate, PrecisionModel precisionModel, int n) {
        Coordinate[] coordinateArray;
        DefaultCoordinateSequenceFactory defaultCoordinateSequenceFactory = DefaultCoordinateSequenceFactory.instance();
        if (coordinate != null) {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = coordinate;
        } else {
            coordinateArray = new Coordinate[]{};
        }
        this(defaultCoordinateSequenceFactory.create(coordinateArray), new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public Point(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(geometryFactory);
        if (coordinateSequence == null) {
            coordinateSequence = geometryFactory.getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        Assert.isTrue((coordinateSequence.size() <= 1 ? 1 : 0) != 0);
        this.coordinates = coordinateSequence;
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray;
        if (this.isEmpty()) {
            coordinateArray = new Coordinate[]{};
        } else {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = this.getCoordinate();
        }
        return coordinateArray;
    }

    public int getNumPoints() {
        return this.isEmpty() ? 0 : 1;
    }

    public boolean isEmpty() {
        return this.getCoordinate() == null;
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public int getDimension() {
        return 0;
    }

    public int getBoundaryDimension() {
        return -1;
    }

    public double getX() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getX called on empty Point");
        }
        return this.getCoordinate().x;
    }

    public double getY() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getY called on empty Point");
        }
        return this.getCoordinate().y;
    }

    public Coordinate getCoordinate() {
        return this.coordinates.size() != 0 ? this.coordinates.getCoordinate(0) : null;
    }

    public String getGeometryType() {
        return "Point";
    }

    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection(null);
    }

    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return new Envelope(this.getCoordinate().x, this.getCoordinate().x, this.getCoordinate().y, this.getCoordinate().y);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return true;
        }
        return this.equal(((Point)geometry).getCoordinate(), this.getCoordinate(), d);
    }

    public void apply(CoordinateFilter coordinateFilter) {
        if (this.isEmpty()) {
            return;
        }
        coordinateFilter.filter(this.getCoordinate());
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    public Object clone() {
        Point point = (Point)super.clone();
        point.coordinates = (CoordinateSequence)this.coordinates.clone();
        return point;
    }

    public void normalize() {
    }

    protected int compareToSameClass(Object object) {
        Point point = (Point)object;
        return this.getCoordinate().compareTo(point.getCoordinate());
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.coordinates;
    }
}

