/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.Arrays;

public class Polygon
extends Geometry {
    protected LinearRing shell = null;
    protected LinearRing[] holes;

    public Polygon(LinearRing linearRing, PrecisionModel precisionModel, int n) {
        this(linearRing, new LinearRing[0], new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public Polygon(LinearRing linearRing, LinearRing[] linearRingArray, PrecisionModel precisionModel, int n) {
        this(linearRing, linearRingArray, new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public Polygon(LinearRing linearRing, LinearRing[] linearRingArray, GeometryFactory geometryFactory) {
        super(geometryFactory);
        if (linearRing == null) {
            linearRing = this.getFactory().createLinearRing((CoordinateSequence)null);
        }
        if (linearRingArray == null) {
            linearRingArray = new LinearRing[]{};
        }
        if (Polygon.hasNullElements(linearRingArray)) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (linearRing.isEmpty() && Polygon.hasNonEmptyElements(linearRingArray)) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
        this.shell = linearRing;
        this.holes = linearRingArray;
    }

    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        int n;
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n2 = -1;
        Coordinate[] coordinateArray2 = this.shell.getCoordinates();
        for (n = 0; n < coordinateArray2.length; ++n) {
            coordinateArray[++n2] = coordinateArray2[n];
        }
        for (n = 0; n < this.holes.length; ++n) {
            Coordinate[] coordinateArray3 = this.holes[n].getCoordinates();
            for (int i = 0; i < coordinateArray3.length; ++i) {
                coordinateArray[++n2] = coordinateArray3[i];
            }
        }
        return coordinateArray;
    }

    public int getNumPoints() {
        int n = this.shell.getNumPoints();
        for (int i = 0; i < this.holes.length; ++i) {
            n += this.holes[i].getNumPoints();
        }
        return n;
    }

    public int getDimension() {
        return 2;
    }

    public int getBoundaryDimension() {
        return 1;
    }

    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    public boolean isSimple() {
        return true;
    }

    public LineString getExteriorRing() {
        return this.shell;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    public LineString getInteriorRingN(int n) {
        return this.holes[n];
    }

    public String getGeometryType() {
        return "Polygon";
    }

    public double getArea() {
        double d = 0.0;
        d += Math.abs(CGAlgorithms.signedArea(this.shell.getCoordinates()));
        for (int i = 0; i < this.holes.length; ++i) {
            d -= Math.abs(CGAlgorithms.signedArea(this.holes[i].getCoordinates()));
        }
        return d;
    }

    public double getLength() {
        double d = 0.0;
        d += this.shell.getLength();
        for (int i = 0; i < this.holes.length; ++i) {
            d += this.holes[i].getLength();
        }
        return d;
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createGeometryCollection(null);
        }
        LineString[] lineStringArray = new LinearRing[this.holes.length + 1];
        lineStringArray[0] = this.shell;
        for (int i = 0; i < this.holes.length; ++i) {
            lineStringArray[i + 1] = this.holes[i];
        }
        return this.getFactory().createMultiLineString(lineStringArray);
    }

    protected Envelope computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        Polygon polygon = (Polygon)geometry;
        LinearRing linearRing = this.shell;
        LinearRing linearRing2 = polygon.shell;
        if (!((Geometry)linearRing).equalsExact(linearRing2, d)) {
            return false;
        }
        if (this.holes.length != polygon.holes.length) {
            return false;
        }
        if (this.holes.length != polygon.holes.length) {
            return false;
        }
        for (int i = 0; i < this.holes.length; ++i) {
            if (((Geometry)this.holes[i]).equalsExact(polygon.holes[i], d)) continue;
            return false;
        }
        return true;
    }

    public void apply(CoordinateFilter coordinateFilter) {
        this.shell.apply(coordinateFilter);
        for (int i = 0; i < this.holes.length; ++i) {
            this.holes[i].apply(coordinateFilter);
        }
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
        this.shell.apply(geometryComponentFilter);
        for (int i = 0; i < this.holes.length; ++i) {
            this.holes[i].apply(geometryComponentFilter);
        }
    }

    public Object clone() {
        Polygon polygon = (Polygon)super.clone();
        polygon.shell = (LinearRing)this.shell.clone();
        polygon.holes = new LinearRing[this.holes.length];
        for (int i = 0; i < this.holes.length; ++i) {
            polygon.holes[i] = (LinearRing)this.holes[i].clone();
        }
        return polygon;
    }

    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    public void normalize() {
        this.normalize(this.shell, true);
        for (int i = 0; i < this.holes.length; ++i) {
            this.normalize(this.holes[i], false);
        }
        Arrays.sort(this.holes);
    }

    protected int compareToSameClass(Object object) {
        LinearRing linearRing = this.shell;
        LinearRing linearRing2 = ((Polygon)object).shell;
        return linearRing.compareToSameClass(linearRing2);
    }

    private void normalize(LinearRing linearRing, boolean bl) {
        if (linearRing.isEmpty()) {
            return;
        }
        Coordinate[] coordinateArray = new Coordinate[linearRing.getCoordinates().length - 1];
        System.arraycopy(linearRing.getCoordinates(), 0, coordinateArray, 0, coordinateArray.length);
        Coordinate coordinate = CoordinateArrays.minCoordinate(linearRing.getCoordinates());
        CoordinateArrays.scroll(coordinateArray, coordinate);
        System.arraycopy(coordinateArray, 0, linearRing.getCoordinates(), 0, coordinateArray.length);
        linearRing.getCoordinates()[coordinateArray.length] = coordinateArray[0];
        RobustCGAlgorithms robustCGAlgorithms = new RobustCGAlgorithms();
        if (((CGAlgorithms)robustCGAlgorithms).isCCW(linearRing.getCoordinates()) == bl) {
            CoordinateArrays.reverse(linearRing.getCoordinates());
        }
    }
}

