/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.filter.Filter;

public abstract class AbstractFeatureSource
implements FeatureSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data");

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public FeatureResults getFeatures(Query query) {
        return new DefaultFeatureResults(this, query);
    }

    public FeatureResults getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    public FeatureResults getFeatures() throws IOException {
        return this.getFeatures(Filter.NONE);
    }

    public Envelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public Envelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.ALL) {
            return new Envelope();
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return null;
        }
        return ((AbstractDataStore)dataStore).getBounds(this.namedQuery(query));
    }

    protected Query namedQuery(Query query) {
        String typeName = this.getSchema().getTypeName();
        if (query.getTypeName() == null || !query.getTypeName().equals(typeName)) {
            return new DefaultQuery(typeName, query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        }
        return query;
    }

    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.ALL) {
            return 0;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return -1;
        }
        return ((AbstractDataStore)dataStore).getCount(this.namedQuery(query));
    }
}

