/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.factory.FactoryFinder;

public final class DataSourceFinder {
    private DataSourceFinder() {
    }

    public static DataSource getDataSource(Map params) throws DataSourceException {
        Iterator ps = DataSourceFinder.getAvailableDataSources();
        while (ps.hasNext()) {
            DataSourceFactorySpi fac = (DataSourceFactorySpi)ps.next();
            if (!fac.canProcess(params)) continue;
            return fac.createDataSource(params);
        }
        return null;
    }

    public static Iterator getAvailableDataSources() {
        return FactoryFinder.factories(DataSourceFactorySpi.class);
    }
}

