/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.AttributeReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;

public class FIDFeatureReader
implements FeatureReader {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    private final AttributeReader attributeReader;
    private final FeatureType schema;
    private final FIDReader fidReader;
    protected final Object[] attributes;

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fidReader, FeatureType schema) throws SchemaException {
        this.attributeReader = attributeReader;
        this.fidReader = fidReader;
        if (schema == null) {
            schema = this.createSchema();
        }
        this.schema = schema;
        this.attributes = new Object[attributeReader.getAttributeCount()];
    }

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fidReader) throws SchemaException {
        this(attributeReader, fidReader, null);
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.attributeReader.hasNext()) {
            this.attributeReader.next();
            return this.readFeature(this.attributeReader);
        }
        throw new NoSuchElementException("There are no more Features to be read");
    }

    protected FeatureType createSchema() throws SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance("xxx");
        int ii = this.attributeReader.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            factory.addType(this.attributeReader.getAttributeType(i));
        }
        return factory.getFeatureType();
    }

    protected Feature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        String fid = this.fidReader.next();
        int ii = atts.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            this.attributes[i] = atts.read(i);
        }
        return this.schema.create(this.attributes, fid);
    }

    public void close() throws IOException {
        this.fidReader.close();
        this.attributeReader.close();
    }

    public FeatureType getFeatureType() {
        return this.schema;
    }

    public boolean hasNext() throws IOException {
        return this.attributeReader.hasNext();
    }
}

