/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.Query;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;
import org.geotools.filter.FilteringIteration;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterFeature;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerFeature;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.gml.GMLReceiver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class GMLDataSource
extends AbstractDataSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.gml");
    private URL url;
    private boolean parsed;
    private FeatureCollection features = FeatureCollections.newCollection();

    public GMLDataSource(String uri) throws DataSourceException {
        this.setUri(uri);
    }

    public GMLDataSource(URL uri) throws DataSourceException {
        this.setUri(uri);
    }

    public void setUri(String uri) throws DataSourceException {
        try {
            this.url = new URL(uri);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException(mue.toString());
        }
    }

    public void setUri(URL uri) throws DataSourceException {
        this.url = uri;
    }

    public void abortLoading() {
    }

    public Set addFeatures(FeatureCollection collection) throws DataSourceException, UnsupportedOperationException {
        return super.addFeatures(collection);
    }

    public Envelope getBounds() throws DataSourceException, UnsupportedOperationException {
        this.parse();
        return this.features.getBounds();
    }

    public FeatureCollection getFeatures(Filter filter) throws DataSourceException {
        FeatureCollection fc = FeatureCollections.newCollection();
        this.getFeatures(fc, filter);
        return fc;
    }

    public FeatureCollection getFeatures(Query query) throws DataSourceException {
        Filter filter = null;
        if (query != null) {
            filter = query.getFilter();
        }
        return this.getFeatures(filter);
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        Filter filter = null;
        if (query != null) {
            filter = query.getFilter();
        }
        this.getFeatures(collection, filter);
    }

    public void getFeatures(FeatureCollection collection, Filter filter) throws DataSourceException {
        this.parse();
        FilteringIteration.filter(this.features, filter);
        collection.addAll(this.features);
    }

    public FeatureCollection getFeatures() throws DataSourceException {
        return this.getFeatures(Query.ALL);
    }

    public FeatureType getSchema() throws DataSourceException {
        this.parse();
        if (this.features.size() > 0) {
            return this.features.features().next().getFeatureType();
        }
        throw new DataSourceException("no features were parsed");
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws DataSourceException, UnsupportedOperationException {
        super.modifyFeatures(type, value, filter);
    }

    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws DataSourceException, UnsupportedOperationException {
        super.modifyFeatures(type, value, filter);
    }

    public void removeFeatures(Filter filter) throws DataSourceException, UnsupportedOperationException {
        super.removeFeatures(filter);
    }

    private InputSource getInputSource() throws DataSourceException {
        InputStream in;
        try {
            in = this.url.openStream();
        }
        catch (IOException e) {
            throw new DataSourceException("Error reading url " + this.url.toString() + " in GMLGeometryDataSource" + "\n" + e);
        }
        return new InputSource(in);
    }

    private void parse() throws DataSourceException {
        LOGGER.finer("has this been parsed before? " + this.parsed);
        if (!this.parsed) {
            try {
                GMLFilterFeature featureFilter = new GMLFilterFeature((GMLHandlerFeature)new GMLReceiver(this.features));
                GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)featureFilter);
                GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
                SAXParserFactory fac = SAXParserFactory.newInstance();
                SAXParser parser = fac.newSAXParser();
                ParserAdapter p = new ParserAdapter(parser.getParser());
                p.setContentHandler((ContentHandler)documentFilter);
                p.parse(this.getInputSource());
                this.parsed = true;
            }
            catch (IOException e) {
                throw new DataSourceException("Error reading URI: " + this.url);
            }
            catch (SAXException e) {
                throw new DataSourceException("Parsing error: " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new DataSourceException("Parsing error: " + e.getMessage());
            }
        }
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport metaData = new AbstractDataSource.MetaDataSupport();
        metaData.setSupportsGetBbox(true);
        return metaData;
    }
}

