/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gml;

import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.data.gml.GMLDataSource;

public class GMLDataSourceFactory
implements DataSourceFactorySpi {
    public boolean canProcess(Map params) {
        if (!params.containsKey("url")) {
            return false;
        }
        String url = (String)params.get("url");
        return url.toUpperCase().endsWith("GML");
    }

    public DataSource createDataSource(Map params) throws DataSourceException {
        if (!this.canProcess(params)) {
            return null;
        }
        String location = (String)params.get("url");
        GMLDataSource ds = new GMLDataSource(location);
        return ds;
    }

    public String getDescription() {
        return "Geographic Markup Language (GML) files version 2.x";
    }
}

