/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.pickle;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class GeometryPickler {
    final int POINT = 1;
    final int LINE = 2;
    final int POLY = 3;
    final int COLLECTION = 10;
    final int MULTI_POINT = 11;
    final int MULTI_LINE = 12;
    final int MULTI_POLY = 13;
    static PrecisionModel pm = new PrecisionModel();
    static int srid = 0;

    public void write(Geometry g, ObjectOutputStream out) throws IOException {
        if (g instanceof GeometryCollection) {
            this.writeCollection((GeometryCollection)g, out);
        } else if (g instanceof Point) {
            this.writePoint(g, out);
        } else if (g instanceof LineString) {
            this.writeLineString(g, out);
        } else if (g instanceof Polygon) {
            this.writePolygon(g, out);
        } else {
            throw new IOException("Cannot write " + g);
        }
    }

    private void writeCollection(GeometryCollection gc, ObjectOutputStream out) throws IOException {
        int cnt = gc.getNumGeometries();
        if (gc instanceof MultiPoint) {
            out.writeByte(11);
        } else if (gc instanceof MultiLineString) {
            out.writeByte(12);
        } else if (gc instanceof MultiPolygon) {
            out.writeByte(13);
        } else {
            out.writeByte(10);
        }
        out.writeShort(cnt);
        for (int i = 0; i < cnt; ++i) {
            this.write(gc.getGeometryN(i), out);
        }
    }

    private void writePoint(Geometry g, ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        Coordinate c = g.getCoordinate();
        out.writeDouble(c.x);
        out.writeDouble(c.y);
        out.writeDouble(c.z);
    }

    private void writeLineString(Geometry g, ObjectOutputStream out) throws IOException {
        out.writeByte(2);
        this.writeCoordinates(g.getCoordinates(), out);
    }

    private void writePolygon(Geometry g, ObjectOutputStream out) throws IOException {
        out.writeByte(3);
        Polygon p = (Polygon)g;
        out.writeShort(p.getNumInteriorRing());
        this.writeLineString(p.getExteriorRing(), out);
        int ii = p.getNumInteriorRing();
        for (int i = 0; i < ii; ++i) {
            this.writeLineString(p.getInteriorRingN(i), out);
        }
    }

    private void writeCoordinates(Coordinate[] c, ObjectOutputStream out) throws IOException {
        out.writeShort(c.length);
        int ii = c.length;
        for (int i = 0; i < ii; ++i) {
            out.writeDouble(c[i].x);
            out.writeDouble(c[i].y);
            out.writeDouble(c[i].z);
        }
    }

    public Geometry read(ObjectInputStream in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return this.readPoint(in);
            }
            case 2: {
                return this.readLine(in, false);
            }
            case 3: {
                return this.readPoly(in);
            }
            case 11: {
                return this.readMultiPoint(in);
            }
            case 12: {
                return this.readMultiLine(in);
            }
            case 13: {
                return this.readMultiPoly(in);
            }
            case 10: {
                return this.readCollection(in);
            }
        }
        throw new IOException("Unknown geometry block : " + type);
    }

    private Coordinate[] readCoords(ObjectInputStream in) throws IOException {
        int len = in.readShort();
        Coordinate[] coords = new Coordinate[len];
        for (int i = 0; i < len; ++i) {
            coords[i] = new Coordinate(in.readDouble(), in.readDouble(), in.readDouble());
        }
        return coords;
    }

    private Point readPoint(ObjectInputStream in) throws IOException {
        Coordinate c = new Coordinate();
        c.x = in.readDouble();
        c.y = in.readDouble();
        c.z = in.readDouble();
        return new Point(c, pm, srid);
    }

    private LineString readLine(ObjectInputStream in, boolean asRing) throws IOException {
        if (asRing) {
            return new LinearRing(this.readCoords(in), pm, srid);
        }
        return new LineString(this.readCoords(in), pm, srid);
    }

    private Polygon readPoly(ObjectInputStream in) throws IOException {
        int interior = in.readShort();
        LinearRing[] interiorRings = new LinearRing[interior];
        in.readByte();
        LinearRing exterior = (LinearRing)this.readLine(in, true);
        for (int i = 0; i < interior; ++i) {
            in.readByte();
            interiorRings[i] = (LinearRing)this.readLine(in, true);
        }
        return new Polygon(exterior, interiorRings, pm, srid);
    }

    private MultiPoint readMultiPoint(ObjectInputStream in) throws IOException {
        int geoms = in.readShort();
        Point[] g = new Point[geoms];
        for (int i = 0; i < geoms; ++i) {
            in.readByte();
            g[i] = this.readPoint(in);
        }
        return new MultiPoint(g, pm, srid);
    }

    private MultiLineString readMultiLine(ObjectInputStream in) throws IOException {
        int geoms = in.readShort();
        LineString[] g = new LineString[geoms];
        for (int i = 0; i < geoms; ++i) {
            in.readByte();
            g[i] = this.readLine(in, false);
        }
        return new MultiLineString(g, pm, srid);
    }

    private MultiPolygon readMultiPoly(ObjectInputStream in) throws IOException {
        int geoms = in.readShort();
        Polygon[] g = new Polygon[geoms];
        for (int i = 0; i < geoms; ++i) {
            in.readByte();
            g[i] = this.readPoly(in);
        }
        return new MultiPolygon(g, pm, srid);
    }

    private GeometryCollection readCollection(ObjectInputStream in) throws IOException {
        int geoms = in.readShort();
        Geometry[] g = new Geometry[geoms];
        for (int i = 0; i < geoms; ++i) {
            g[i] = this.read(in);
        }
        return new GeometryCollection(g, pm, srid);
    }
}

