/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.pickle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.Query;
import org.geotools.data.pickle.PickledFeatureProtocol;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;

public class PickleDataSource
extends AbstractDataSource {
    final String objectFile;
    final String classFile;

    public PickleDataSource(File parent, String name) {
        this.objectFile = new File(parent, name + ".obj").getAbsolutePath();
        this.classFile = new File(parent, name + ".clz").getAbsolutePath();
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport mds = new AbstractDataSource.MetaDataSupport();
        mds.setSupportsSetFeatures(true);
        return mds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFeatures(FeatureCollection collection) throws DataSourceException {
        FileOutputStream obj = null;
        FileOutputStream clz = null;
        PickledFeatureProtocol protocol = null;
        try {
            try {
                obj = new FileOutputStream(this.objectFile);
                clz = new FileOutputStream(this.classFile);
                protocol = PickledFeatureProtocol.getWriter(obj, clz);
                protocol.write(collection);
            }
            catch (IOException ioe) {
                throw new DataSourceException("IOError", ioe);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (obj != null) {
                    obj.close();
                }
                if (clz != null) {
                    clz.close();
                }
                if (protocol == null) throw throwable;
                protocol.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (obj != null) {
            obj.close();
        }
        if (clz != null) {
            clz.close();
        }
        if (protocol == null) return;
        protocol.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        PickledFeatureProtocol protocol = null;
        try {
            FileInputStream obj = new FileInputStream(this.objectFile);
            FileInputStream clz = new FileInputStream(this.classFile);
            protocol = PickledFeatureProtocol.getReader(obj, clz);
            protocol.read(collection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                protocol.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Feature getFeature(int idx) throws DataSourceException {
        FileInputStream obj = null;
        FileInputStream clz = null;
        PickledFeatureProtocol protocol = null;
        obj = new FileInputStream(this.objectFile);
        clz = new FileInputStream(this.classFile);
        protocol = PickledFeatureProtocol.getReader(obj, clz);
        Feature feature = protocol.read(idx);
        Object var7_7 = null;
        try {
            if (obj != null) {
                obj.close();
            }
            if (clz != null) {
                clz.close();
            }
            if (protocol != null) {
                protocol.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return feature;
        catch (Exception e) {
            try {
                e.printStackTrace();
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (obj != null) {
                        obj.close();
                    }
                    if (clz != null) {
                        clz.close();
                    }
                    if (protocol != null) {
                        protocol.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (obj != null) {
                    obj.close();
                }
                if (clz != null) {
                    clz.close();
                }
                if (protocol != null) {
                    protocol.close();
                }
            }
            catch (Exception e2) {}
        }
        return null;
    }

    public FeatureType getSchema() throws DataSourceException {
        return null;
    }
}

