/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.TopologyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileUtilities;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;

public class ShapefileDataSource
extends AbstractDataSource {
    private URL shpURL;
    private URL dbfURL;
    private URL shxURL;
    private FeatureType schema = null;
    private IDFactory idFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public ShapefileDataSource(URL url) throws MalformedURLException {
        String filename = null;
        if (url == null) {
            throw new NullPointerException("Null URL for ShapefileDataSource");
        }
        try {
            filename = URLDecoder.decode(url.toString(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        String shpext = ".shp";
        String dbfext = ".dbf";
        String shxext = ".shx";
        if (filename.endsWith(shpext) || filename.endsWith(dbfext) || filename.endsWith(shxext)) {
            filename = filename.substring(0, filename.length() - 4);
        } else if (filename.endsWith(".SHP") || filename.endsWith(".DBF") || filename.endsWith(".SHX")) {
            filename = filename.substring(0, filename.length() - 4);
            shpext = ".SHP";
            dbfext = ".DBF";
            shxext = ".SHX";
        }
        this.shpURL = new URL(filename + shpext);
        this.dbfURL = new URL(filename + dbfext);
        this.shxURL = new URL(filename + shxext);
    }

    public IDFactory getIDFactory() {
        if (this.idFactory == null) {
            this.idFactory = new DefaultIDFactory();
        }
        return this.idFactory;
    }

    public void setIDFactory(IDFactory f) {
        this.idFactory = f;
    }

    public void abortLoading() {
    }

    public Envelope getBounds() throws DataSourceException {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(100);
            ReadableByteChannel in = ShapefileDataSource.getReadChannel(this.shpURL);
            in.read(buffer);
            buffer.flip();
            ShapefileHeader header = new ShapefileHeader();
            header.read(buffer, true);
            return new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
        }
        catch (IOException ioe) {
            throw new DataSourceException("Problem getting Bbox", ioe);
        }
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        try {
            ReadableByteChannel channel;
            Filter filter = null;
            if (query != null) {
                filter = query.getFilter();
            }
            if ((channel = ShapefileDataSource.getReadChannel(this.shpURL)) == null) {
                throw new DataSourceException("Non existent file or problems opening file: " + this.shpURL);
            }
            ShapefileReader shp = new ShapefileReader(channel);
            DbaseFileReader dbf = this.createDbaseReader();
            int[] mapping = query.retrieveAllProperties() ? new int[dbf.getHeader().getNumFields() + 1] : new int[query.getPropertyNames().length];
            FeatureType type = this.getSchema(shp, dbf, query, mapping);
            FeatureMaker features = new FeatureMaker(dbf, shp, type, mapping);
            while (features.hasNext()) {
                Feature f = features.next();
                if (filter != null && !filter.contains(f)) continue;
                collection.add(f);
            }
            shp.close();
            if (dbf != null) {
                dbf.close();
            }
        }
        catch (IOException ioe) {
            throw new DataSourceException("IO Exception loading data", ioe);
        }
        catch (TopologyException te) {
            throw new DataSourceException("Topology Exception loading data", te);
        }
        catch (IllegalAttributeException ife) {
            throw new DataSourceException("Illegal Attribute Exception loading data", ife);
        }
    }

    private FeatureType getSchema(ShapefileReader shp, DbaseFileReader dbf, Query q, int[] sel) throws DataSourceException, IOException, ShapefileException {
        this.schema = this.getFeatureType(dbf == null ? this.createDbaseReader() : dbf, shp == null ? new ShapefileReader(ShapefileDataSource.getReadChannel(this.shpURL)) : shp, q, sel);
        return this.schema;
    }

    public FeatureType getSchema() throws DataSourceException {
        try {
            return this.getSchema(null, null, new DefaultQuery(), null);
        }
        catch (ShapefileException e) {
            throw new DataSourceException("Invalid Shapefile", e);
        }
        catch (IOException e) {
            throw new DataSourceException("IO problem reading shapefile", e);
        }
    }

    public void setSchema(FeatureType schema) throws DataSourceException {
        this.schema = schema;
    }

    private DbaseFileReader createDbaseReader() throws IOException {
        ReadableByteChannel channel;
        DbaseFileReader reader = null;
        if (this.dbfURL != null && (channel = ShapefileDataSource.getReadChannel(this.dbfURL)) != null) {
            reader = new DbaseFileReader(channel);
        }
        return reader;
    }

    private static ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            if (!file.exists() || !file.canRead()) {
                throw new IOException("File either doesn't exist or is unreadable : " + file);
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    private static WritableByteChannel getWriteChannel(URL url) throws IOException {
        WritableByteChannel channel;
        if (url.getProtocol().equals("file")) {
            File f = new File(url.getFile());
            f.delete();
            if (!f.exists() && !f.createNewFile()) {
                throw new IOException("Cannot create file " + f);
            }
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            channel = raf.getChannel();
        } else {
            OutputStream out = url.openConnection().getOutputStream();
            channel = Channels.newChannel(out);
        }
        return channel;
    }

    protected AttributeType[] determineAttributeTypes(AttributeType[] ds, Query q, int[] sel) {
        AttributeType[] attTypes;
        if (q.retrieveAllProperties()) {
            int ii = sel.length;
            for (int i = 0; i < ii; ++i) {
                sel[i] = i;
            }
            attTypes = ds;
        } else {
            HashMap<String, Object[]> positions = new HashMap<String, Object[]>(ds.length);
            int ii = ds.length;
            for (int i = 0; i < ii; ++i) {
                positions.put(ds[i].getName(), new Object[]{new Integer(i), ds[i]});
            }
            String[] qat = q.getPropertyNames();
            ArrayList<Object> types = new ArrayList<Object>(qat.length);
            int ii2 = qat.length;
            for (int i = 0; i < ii2; ++i) {
                Object[] entry = (Object[])positions.get(qat[i]);
                int n = sel[i] = entry == null ? -1 : (Integer)entry[0];
                if (sel[i] < 0) continue;
                types.add(entry[1]);
            }
            attTypes = types.toArray(new AttributeType[types.size()]);
        }
        return attTypes;
    }

    private AttributeType[] getAttributeTypes(DbaseFileReader dbf, ShapeType type) {
        AttributeType[] atts;
        AttributeType geometryAttribute = AttributeTypeFactory.newAttributeType("the_geom", JTSUtilities.findBestGeometryClass(type));
        if (dbf != null) {
            DbaseFileHeader header = dbf.getHeader();
            atts = new AttributeType[header.getNumFields() + 1];
            atts[0] = geometryAttribute;
            int ii = header.getNumFields();
            for (int i = 0; i < ii; ++i) {
                Class clazz = header.getFieldClass(i);
                atts[i + 1] = AttributeTypeFactory.newAttributeType(header.getFieldName(i), clazz);
            }
        } else {
            atts = new AttributeType[]{geometryAttribute};
        }
        return atts;
    }

    private FeatureType getFeatureType(DbaseFileReader dbf, ShapefileReader shp, Query q, int[] sel) throws IOException, DataSourceException {
        ShapeType t = shp.getHeader().getShapeType();
        AttributeType[] types = this.getAttributeTypes(dbf, t);
        if (sel == null) {
            sel = new int[types.length];
            int ii = sel.length;
            for (int i = 0; i < ii; ++i) {
                sel[i] = i;
            }
        }
        types = this.determineAttributeTypes(types, q, sel);
        try {
            return FeatureTypeFactory.newFeatureType(types, this.getTypeName());
        }
        catch (SchemaException se) {
            throw new DataSourceException("Schema Error", se);
        }
    }

    protected final DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport shpMeta = new AbstractDataSource.MetaDataSupport();
        shpMeta.setSupportsGetBbox(true);
        shpMeta.setFastBbox(true);
        shpMeta.setSupportsSetFeatures(true);
        return shpMeta;
    }

    private String getTypeName() {
        String path = this.shpURL.getPath();
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            dot = path.length();
        }
        int slash = path.lastIndexOf(47) + 1;
        return path.substring(slash, dot);
    }

    public void setFeatures(FeatureCollection collection) throws DataSourceException {
        try {
            GeometryCollection gc = this.makeShapeGeometryCollection(collection);
            int shapeDims = 2;
            if (gc.getNumGeometries() > 0) {
                shapeDims = JTSUtilities.guessCoorinateDims(gc.getGeometryN(0).getCoordinates());
            }
            ShapefileWriter writer = new ShapefileWriter((FileChannel)ShapefileDataSource.getWriteChannel(this.shpURL), (FileChannel)ShapefileDataSource.getWriteChannel(this.shxURL));
            writer.write(gc, JTSUtilities.getShapeType(gc.getGeometryN(0), shapeDims));
            this.writeDbf(collection);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Something went wrong during shapefile saving", se);
        }
        catch (DbaseFileException dfe) {
            throw new DataSourceException("Something went wrong during shapefile saving", dfe);
        }
        catch (IOException e) {
            throw new DataSourceException("IOException during shapefile saving", e);
        }
        catch (RuntimeException e) {
            throw new DataSourceException("Something went wrong during shapefile saving", e);
        }
    }

    private void writeDbf(FeatureCollection featureCollection) throws DbaseFileException, IOException {
        FeatureIterator it = featureCollection.features();
        if (!it.hasNext()) {
            throw new IOException("Empty featureCollection");
        }
        AttributeType[] types = it.next().getFeatureType().getAttributeTypes();
        int[] supported = new int[types.length];
        int numAttributes = 0;
        for (int i = 0; i < types.length; ++i) {
            Class currType = types[i].getType();
            if (currType == (class$java$lang$String == null ? ShapefileDataSource.class$("java.lang.String") : class$java$lang$String) || currType == (class$java$lang$Boolean == null ? ShapefileDataSource.class$("java.lang.Boolean") : class$java$lang$Boolean) || (class$java$lang$Number == null ? ShapefileDataSource.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(currType) || (class$java$util$Date == null ? ShapefileDataSource.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(currType)) {
                supported[i] = ++numAttributes;
                continue;
            }
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? ShapefileDataSource.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(currType)) continue;
            throw new DbaseFileException("Shapefile: unsupported type found in feature schema : " + currType.getName());
        }
        DbaseFileHeader header = new DbaseFileHeader();
        for (int i = 0; i < types.length; ++i) {
            Class colType = types[i].getType();
            String colName = types[i].getName();
            if (colType == (class$java$lang$Integer == null ? ShapefileDataSource.class$("java.lang.Integer") : class$java$lang$Integer) || colType == (class$java$lang$Short == null ? ShapefileDataSource.class$("java.lang.Short") : class$java$lang$Short) || colType == (class$java$lang$Byte == null ? ShapefileDataSource.class$("java.lang.Byte") : class$java$lang$Byte)) {
                header.addColumn(colName, 'N', 16, 0);
                continue;
            }
            if (colType == (class$java$lang$Double == null ? ShapefileDataSource.class$("java.lang.Double") : class$java$lang$Double) || colType == (class$java$lang$Float == null ? ShapefileDataSource.class$("java.lang.Float") : class$java$lang$Float) || colType == (class$java$lang$Number == null ? ShapefileDataSource.class$("java.lang.Number") : class$java$lang$Number)) {
                header.addColumn(colName, 'N', 33, 16);
                continue;
            }
            if ((class$java$util$Date == null ? ShapefileDataSource.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(colType)) {
                header.addColumn(colName, 'D', 8, 0);
                continue;
            }
            if (colType == (class$java$lang$Boolean == null ? ShapefileDataSource.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                header.addColumn(colName, 'L', 1, 0);
                continue;
            }
            if (colType == (class$java$lang$String == null ? ShapefileDataSource.class$("java.lang.String") : class$java$lang$String)) {
                int maxlength = this.findMaxStringLength(featureCollection, i);
                if (maxlength > 255) {
                    throw new DbaseFileException("Shapefile does not support strings longer than 255 characters");
                }
                header.addColumn(colName, 'C', Math.max(1, maxlength), 0);
                continue;
            }
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? ShapefileDataSource.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(colType)) continue;
            throw new DbaseFileException("Unable to write : " + colType.getName());
        }
        header.setNumRecords(featureCollection.size());
        DbaseFileWriter dbf = new DbaseFileWriter(header, ShapefileDataSource.getWriteChannel(this.dbfURL));
        Object[] dbrow = new Object[numAttributes];
        Object[] attVals = new Object[types.length];
        it = featureCollection.features();
        while (it.hasNext()) {
            it.next().getAttributes(attVals);
            int idx = 0;
            for (int j = 0; j < types.length; ++j) {
                if (supported[j] <= 0) continue;
                dbrow[idx++] = ShapefileUtilities.forAttribute(attVals[j], types[j].getType());
            }
            dbf.write(dbrow);
        }
        dbf.close();
    }

    private int findMaxStringLength(FeatureCollection fc, int attributeNumber) {
        Iterator i = fc.iterator();
        int maxlen = 0;
        while (i.hasNext()) {
            int len;
            Feature f = (Feature)i.next();
            String s = (String)f.getAttribute(attributeNumber);
            if (s == null || (len = s.length()) <= maxlen) continue;
            maxlen = len;
        }
        return maxlen;
    }

    public GeometryCollection makeShapeGeometryCollection(FeatureCollection fc) throws DataSourceException {
        Geometry[] allGeoms = new Geometry[fc.size()];
        Iterator i = fc.iterator();
        if (!i.hasNext()) {
            throw new DataSourceException("Feature Collection is empty");
        }
        Feature f1 = (Feature)i.next();
        if (f1.getFeatureType().getDefaultGeometry() == null) {
            throw new DataSourceException("Feature has no geometry");
        }
        ShapeType type = JTSUtilities.findBestGeometryType(f1.getDefaultGeometry());
        if (type == ShapeType.NULL) {
            throw new DataSourceException("Could not determine shapefile type - data is either all GeometryCollections or empty");
        }
        i = fc.iterator();
        int t = 0;
        while (i.hasNext()) {
            Geometry geom = ((Feature)i.next()).getDefaultGeometry();
            allGeoms[t++] = JTSUtilities.convertToCollection(geom, type);
        }
        GeometryCollection result = new GeometryCollection(allGeoms, allGeoms[0].getPrecisionModel(), allGeoms[0].getSRID());
        return result;
    }

    public class DefaultIDFactory
    implements IDFactory {
        final String file;

        public DefaultIDFactory() {
            this.file = ShapefileDataSource.this.getTypeName();
        }

        public String getFeatureID(int record) {
            return this.file + "." + record;
        }
    }

    public static interface IDFactory {
        public String getFeatureID(int var1);
    }

    final class FeatureMaker {
        final int[] mapping;
        final DbaseFileReader dbf;
        final ShapefileReader shp;
        final Object[] readStash;
        final Object[] writeStash;
        final FeatureType type;
        final IDFactory id;
        int cnt = 0;

        public FeatureMaker(DbaseFileReader dbf, ShapefileReader shp, FeatureType type, int[] mapping) {
            this.dbf = dbf;
            this.shp = shp;
            this.mapping = mapping;
            this.type = type;
            this.readStash = new Object[dbf.getHeader().getNumFields()];
            this.writeStash = new Object[type.getAttributeTypes().length];
            this.id = ShapefileDataSource.this.getIDFactory();
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasNext() throws IOException {
            void var2_2;
            boolean more;
            int both = (this.shp.hasNext() ? 1 : 0) + (this.dbf.hasNext() ? 2 : 0);
            if (both == 3) {
                more = true;
            } else if (both == 0) {
                more = false;
            } else {
                throw new IllegalStateException((both == 1 ? "shape" : "dbf") + "file has extra record (count = " + this.cnt + ")");
            }
            return (boolean)var2_2;
        }

        public Feature next() throws IOException, IllegalAttributeException {
            ShapefileReader.Record record = this.shp.nextRecord();
            DbaseFileReader.Row row = null;
            if (this.dbf != null) {
                row = this.dbf.readRow();
            }
            int ii = this.writeStash.length;
            for (int i = 0; i < ii; ++i) {
                int idx = this.mapping[i];
                if (idx == 0) {
                    this.writeStash[i] = record.shape();
                    continue;
                }
                if (idx == -1) {
                    this.writeStash[i] = null;
                    continue;
                }
                if (row == null) continue;
                this.writeStash[i] = row.read(idx - 1);
            }
            return this.type.create(this.writeStash, this.id.getFeatureID(++this.cnt));
        }
    }
}

