/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.shapefile.ShapefileDataStore;

public class ShapefileDataStoreFactory
implements DataStoreFactorySpi {
    private static final DataStoreFactorySpi.Param URLP = new DataStoreFactorySpi.Param("url", URL.class, "url to a .shp file");
    private static final DataStoreFactorySpi.Param MEMORY_MAPPED = new DataStoreFactorySpi.Param("memory mapped buffer", Boolean.class, "enable/disable the use of memory-mapped io", false);

    public boolean canProcess(Map params) {
        boolean accept = false;
        if (params.containsKey(ShapefileDataStoreFactory.URLP.key)) {
            try {
                URL url = (URL)URLP.lookUp(params);
                accept = url.getFile().toUpperCase().endsWith("SHP");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return accept;
    }

    public DataStore createDataStore(Map params) throws IOException {
        ShapefileDataStore ds = null;
        URL url = null;
        try {
            url = (URL)URLP.lookUp(params);
            Boolean mm = (Boolean)MEMORY_MAPPED.lookUp(params);
            if (mm == null) {
                mm = Boolean.TRUE;
            }
            ds = new ShapefileDataStore(url, mm);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Unable to attatch datastore to " + url, mue);
        }
        return ds;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public boolean isAvailable() {
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{URLP, MEMORY_MAPPED};
    }
}

