/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.LocalCoordinateSystem;
import org.geotools.feature.AttributeType;
import org.geotools.feature.CSGeometryFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultAttributeType
implements AttributeType {
    protected final String name;
    protected final Class type;
    protected final boolean nillable;
    protected final int fieldLength;
    protected Object defaultValue;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$org$geotools$feature$Feature;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    protected DefaultAttributeType(String name, Class type, boolean nillable, int fieldLength, Object defaultValue) {
        String string = this.name = name == null ? "" : name;
        Class clazz = type == null ? Object.class : type;
        this.type = clazz;
        this.nillable = nillable;
        this.fieldLength = fieldLength;
        this.defaultValue = defaultValue;
    }

    protected DefaultAttributeType(AttributeType copy) {
        this.name = copy.getName();
        this.type = copy.getType();
        this.nillable = copy.isNillable();
        this.fieldLength = copy.getFieldLength();
        this.defaultValue = copy.createDefaultValue();
    }

    public boolean isNested() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        if (src == null) {
            return null;
        }
        if (src instanceof String || src instanceof Integer || src instanceof Double || src instanceof Float || src instanceof Byte || src instanceof Boolean || src instanceof Short || src instanceof Long || src instanceof Character || src instanceof Number) {
            return src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof Object[]) {
            Object[] array = (Object[])src;
            Object[] copy = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                copy[i] = this.duplicate(array[i]);
            }
            return copy;
        }
        if (src instanceof Geometry) {
            Geometry geometry = (Geometry)src;
            return geometry.clone();
        }
        if (src instanceof org.geotools.feature.Feature) {
            org.geotools.feature.Feature feature = (org.geotools.feature.Feature)src;
            return feature.getFeatureType().duplicate(feature);
        }
        Class<?> type = src.getClass();
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            System.arraycopy(src, 0, copy, 0, length);
            return copy;
        }
        if (type.isArray()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(copy, i, this.duplicate(Array.get(src, i)));
            }
            return copy;
        }
        if (src instanceof List) {
            List list = (List)src;
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                copy.add(this.duplicate(i.next()));
            }
            return Collections.unmodifiableList(copy);
        }
        if (src instanceof Map) {
            Map map = (Map)src;
            HashMap copy = new HashMap(map.size());
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                copy.put(entry.getKey(), this.duplicate(entry.getValue()));
            }
            return Collections.unmodifiableMap(copy);
        }
        throw new IllegalAttributeException("Do not know how to deep copy " + type.getName());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        AttributeType att = (AttributeType)other;
        if (this.name == null && att.getName() != null) {
            return false;
        }
        if (!this.name.equals(att.getName())) {
            return false;
        }
        return this.type.equals(att.getType());
    }

    public boolean isGeometry() {
        return Geometry.class.isAssignableFrom(this.type);
    }

    public String toString() {
        String details = "name=" + this.name;
        details = details + " , type=" + this.type;
        details = details + " , nillable=" + this.nillable;
        return "DefaultAttributeType [" + details + "]";
    }

    public Object parse(Object value) throws IllegalArgumentException {
        return value;
    }

    public void validate(Object attribute) throws IllegalArgumentException {
        if (attribute == null) {
            if (!this.isNillable()) {
                throw new IllegalArgumentException(this.getName() + " is not nillable");
            }
            return;
        }
        if (!this.type.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(attribute.getClass().getName() + " is not an acceptable class for " + this.getName() + " as it is not assignable from " + this.type);
        }
    }

    public Object createDefaultValue() {
        return this.defaultValue;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public static class Geometric
    extends DefaultAttributeType
    implements GeometryAttributeType {
        protected CoordinateReferenceSystem coordinateSystem;
        protected GeometryFactory geometryFactory;

        public Geometric(String name, Class type, boolean nillable, int fieldLength, Object defaultValue, CoordinateReferenceSystem cs) {
            super(name, type, nillable, fieldLength, defaultValue);
            this.coordinateSystem = cs;
            this.geometryFactory = cs == null ? CSGeometryFactory.DEFAULT : new CSGeometryFactory(cs);
        }

        public Geometric(GeometryAttributeType copy, CoordinateSystem override) {
            super(copy);
            this.coordinateSystem = (CoordinateSystem)copy.getCoordinateSystem();
            if (override != null) {
                this.coordinateSystem = override;
            }
            if (this.coordinateSystem == null) {
                this.coordinateSystem = LocalCoordinateSystem.PROMISCUOUS;
            }
            this.geometryFactory = this.coordinateSystem == LocalCoordinateSystem.PROMISCUOUS ? CSGeometryFactory.DEFAULT : new CSGeometryFactory(this.coordinateSystem);
        }

        public CoordinateReferenceSystem getCoordinateSystem() {
            return this.coordinateSystem;
        }

        public GeometryFactory getGeometryFactory() {
            return this.geometryFactory;
        }

        public Object parse(Object value) throws IllegalArgumentException {
            if (value == null) {
                return value;
            }
            if (value instanceof Geometry) {
                return value;
            }
            throw new RuntimeException("DefaultAttribute.Geometric cannot parse " + value);
        }

        public Object duplicate(Object o) throws IllegalAttributeException {
            if (o == null) {
                return o;
            }
            if (o instanceof Geometry) {
                return ((Geometry)o).clone();
            }
            throw new IllegalAttributeException("Cannot duplicate " + o.getClass().getName());
        }
    }

    static class Temporal
    extends DefaultAttributeType {
        static DateFormat format = DateFormat.getInstance();

        public Temporal(String name, boolean nillable, int fieldLength, Object defaultValue) {
            super(name, class$java$util$Date == null ? (class$java$util$Date = DefaultAttributeType.class$("java.util.Date")) : class$java$util$Date, nillable, fieldLength, defaultValue);
        }

        public Object parse(Object value) throws IllegalArgumentException {
            if (value == null) {
                return value;
            }
            if (this.type.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (value instanceof Number) {
                return new Date(((Number)value).longValue());
            }
            if (value instanceof Calendar) {
                return ((Calendar)value).getTime();
            }
            try {
                return format.parse(value.toString());
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("unable to parse " + value + " as Date");
            }
        }

        public Object duplicate(Object o) throws IllegalAttributeException {
            if (o == null) {
                return null;
            }
            if (o instanceof Date) {
                Date d = (Date)o;
                return new Date(d.getTime());
            }
            throw new IllegalAttributeException("Cannot duplicate " + o.getClass().getName());
        }
    }

    static class Textual
    extends DefaultAttributeType {
        public Textual(String name, boolean nillable, int fieldLength, Object defaultValue) {
            super(name, class$java$lang$String == null ? (class$java$lang$String = DefaultAttributeType.class$("java.lang.String")) : class$java$lang$String, nillable, fieldLength, defaultValue);
        }

        public Object parse(Object value) throws IllegalArgumentException {
            if (value == null) {
                return value;
            }
            if (value instanceof String) {
                return value;
            }
            return value.toString();
        }

        public Object duplicate(Object o) {
            if (o == null) {
                return null;
            }
            return o.toString();
        }
    }

    static class Feature
    extends DefaultAttributeType {
        private final FeatureType featureType;

        public Feature(String name, FeatureType type, boolean nillable, Object defaultValue) {
            super(name, class$org$geotools$feature$Feature == null ? (class$org$geotools$feature$Feature = DefaultAttributeType.class$("org.geotools.feature.Feature")) : class$org$geotools$feature$Feature, nillable, 0, defaultValue);
            this.featureType = type;
        }

        public Object duplicate(Object o) throws IllegalAttributeException {
            if (o instanceof org.geotools.feature.Feature) {
                org.geotools.feature.Feature f = (org.geotools.feature.Feature)o;
                return f.getFeatureType().duplicate(f);
            }
            if (o == null) {
                return o;
            }
            throw new IllegalAttributeException("Could not duplicate " + o.getClass().getName());
        }

        public void validate(Object attribute) throws IllegalArgumentException {
            super.validate(attribute);
            org.geotools.feature.Feature att = (org.geotools.feature.Feature)attribute;
            if (att == null) {
                return;
            }
            if (!att.getFeatureType().isDescendedFrom(this.featureType) && !att.getFeatureType().equals(this.featureType)) {
                throw new IllegalArgumentException("Not correct FeatureType, expected " + this.featureType + " got " + att.getFeatureType());
            }
        }
    }

    static class Numeric
    extends DefaultAttributeType {
        public Numeric(String name, Class type, boolean nillable, int fieldLength, Object defaultValue) throws IllegalArgumentException {
            super(name, type, nillable, fieldLength, defaultValue);
            if (!(class$java$lang$Number == null ? (class$java$lang$Number = DefaultAttributeType.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type)) {
                throw new IllegalArgumentException("Numeric requires Number class, not " + type);
            }
        }

        public Object parse(Object value) throws IllegalArgumentException {
            Object parsed;
            if (value == null) {
                return value;
            }
            if (value.getClass() == this.type || this.type.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (value instanceof Number) {
                return this.convertNumber((Number)value);
            }
            String str = value.toString();
            try {
                parsed = this.parseFromString(str);
                if (parsed != null) {
                    return parsed;
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            if ((str.length() == 0 || str.trim().length() == 0) && (parsed = this.parseFromString("0")) != null) {
                return parsed;
            }
            throw new IllegalArgumentException("Cannot parse " + value.getClass());
        }

        public Object duplicate(Object o) {
            return o;
        }

        protected Object parseFromString(String value) throws IllegalArgumentException {
            Object parsed = null;
            if (this.type == (class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultAttributeType.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return Byte.decode(value);
            }
            if (this.type == (class$java$lang$Short == null ? (class$java$lang$Short = DefaultAttributeType.class$("java.lang.Short")) : class$java$lang$Short)) {
                return Short.decode(value);
            }
            if (this.type == (class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultAttributeType.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return Integer.decode(value);
            }
            if (this.type == (class$java$lang$Float == null ? (class$java$lang$Float = DefaultAttributeType.class$("java.lang.Float")) : class$java$lang$Float)) {
                return Float.valueOf(value);
            }
            if (this.type == (class$java$lang$Double == null ? (class$java$lang$Double = DefaultAttributeType.class$("java.lang.Double")) : class$java$lang$Double)) {
                return Double.valueOf(value);
            }
            if (this.type == (class$java$lang$Long == null ? (class$java$lang$Long = DefaultAttributeType.class$("java.lang.Long")) : class$java$lang$Long)) {
                return Long.decode(value);
            }
            if (this.type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = DefaultAttributeType.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                return new BigInteger(value);
            }
            if (this.type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DefaultAttributeType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                return new BigDecimal(value);
            }
            if ((class$java$lang$Number == null ? (class$java$lang$Number = DefaultAttributeType.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.type)) {
                return new Double(value);
            }
            return null;
        }

        protected Object convertNumber(Number number) {
            if (this.type == (class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultAttributeType.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte(number.byteValue());
            }
            if (this.type == (class$java$lang$Short == null ? (class$java$lang$Short = DefaultAttributeType.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short(number.shortValue());
            }
            if (this.type == (class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultAttributeType.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(number.intValue());
            }
            if (this.type == (class$java$lang$Float == null ? (class$java$lang$Float = DefaultAttributeType.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(number.floatValue());
            }
            if (this.type == (class$java$lang$Double == null ? (class$java$lang$Double = DefaultAttributeType.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(number.doubleValue());
            }
            if (this.type == (class$java$lang$Long == null ? (class$java$lang$Long = DefaultAttributeType.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(number.longValue());
            }
            if (this.type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = DefaultAttributeType.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                return BigInteger.valueOf(number.longValue());
            }
            if (this.type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DefaultAttributeType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                return BigDecimal.valueOf(number.longValue());
            }
            throw new RuntimeException("DefaultAttribute.Numeric cannot parse " + number);
        }
    }
}

