/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultAttributeTypeFactory
extends AttributeTypeFactory {
    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength) {
        return this.createAttributeType(name, clazz, isNillable, fieldLength, null);
    }

    protected AttributeType createAttributeType(String name, FeatureType type, boolean isNillable) {
        return new DefaultAttributeType.Feature(name, type, isNillable, null);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue) {
        if (Number.class.isAssignableFrom(clazz)) {
            return new DefaultAttributeType.Numeric(name, clazz, isNillable, fieldLength, defaultValue);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return new DefaultAttributeType.Textual(name, isNillable, fieldLength, defaultValue);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DefaultAttributeType.Temporal(name, isNillable, fieldLength, defaultValue);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            return new DefaultAttributeType.Geometric(name, clazz, isNillable, fieldLength, defaultValue, null);
        }
        return new DefaultAttributeType(name, clazz, isNillable, fieldLength, defaultValue);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue, Object metaData) {
        if (Geometry.class.isAssignableFrom(clazz) && metaData instanceof CoordinateReferenceSystem) {
            return new DefaultAttributeType.Geometric(name, clazz, isNillable, fieldLength, defaultValue, (CoordinateReferenceSystem)metaData);
        }
        return this.createAttributeType(name, clazz, isNillable, fieldLength, defaultValue);
    }
}

