/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.rmi.server.UID;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.util.Cloneable;

public class DefaultFeature
implements Feature,
Cloneable {
    protected String featureId;
    private final DefaultFeatureType schema;
    private Object[] attributes;
    private Envelope bounds;
    private FeatureCollection parent;

    protected DefaultFeature(DefaultFeatureType schema, Object[] attributes, String featureID) throws IllegalAttributeException, NullPointerException {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        this.schema = schema;
        this.featureId = featureID == null ? this.defaultID() : featureID;
        this.attributes = new Object[schema.getAttributeCount()];
        this.setAttributes(attributes);
    }

    protected DefaultFeature(DefaultFeatureType schema, Object[] attributes) throws IllegalAttributeException {
        this(schema, attributes, null);
    }

    String defaultID() {
        return "fid-" + new UID().toString();
    }

    public FeatureType getFeatureType() {
        return this.schema;
    }

    public String getID() {
        return this.featureId;
    }

    public Object[] getAttributes(Object[] array) {
        Object[] retArray = array == null ? new Object[this.attributes.length] : array;
        System.arraycopy(this.attributes, 0, retArray, 0, this.attributes.length);
        return retArray;
    }

    public Object getAttribute(String xPath) {
        int idx = this.schema.find(xPath);
        if (idx == -1) {
            return null;
        }
        return this.attributes[idx];
    }

    public Object getAttribute(int index) {
        return this.attributes[index];
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException {
        AttributeType type = this.schema.getAttributeType(position);
        try {
            Object parsed = type.parse(val);
            type.validate(parsed);
            this.attributes[position] = parsed;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalAttributeException(type, val, iae);
        }
    }

    public void setAttributes(Object[] attributes) throws IllegalAttributeException {
        Object[] newAtts = attributes;
        if (attributes == null) {
            newAtts = new Object[this.attributes.length];
        }
        if (newAtts.length != this.attributes.length) {
            throw new IllegalAttributeException("Wrong number of attributes expected " + this.schema.getAttributeCount() + " got " + newAtts.length);
        }
        int ii = newAtts.length;
        for (int i = 0; i < ii; ++i) {
            this.setAttribute(i, newAtts[i]);
        }
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        int idx = this.schema.find(xPath);
        if (idx < 0) {
            throw new IllegalAttributeException("No attribute named " + xPath);
        }
        this.setAttribute(idx, attribute);
    }

    public Geometry getDefaultGeometry() {
        int idx = this.schema.defaultGeomIdx;
        if (idx == -1) {
            return null;
        }
        return (Geometry)this.attributes[idx];
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        int idx = this.schema.defaultGeomIdx;
        if (idx < 0) {
            throw new IllegalAttributeException("Feature does not have geometry");
        }
        this.attributes[idx] = geometry;
        this.bounds = null;
    }

    public int getNumberOfAttributes() {
        return this.attributes.length;
    }

    public Envelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new Envelope();
            int n = this.schema.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                Envelope e;
                Geometry g;
                if (!this.schema.getAttributeType(i).isGeometry() || (g = (Geometry)this.attributes[i]) == null || (e = g.getEnvelopeInternal()).isNull()) continue;
                this.bounds.expandToInclude(e);
            }
        }
        return new Envelope(this.bounds);
    }

    public Object clone() {
        try {
            DefaultFeature clone = (DefaultFeature)super.clone();
            for (int i = 0; i < this.attributes.length; ++i) {
                try {
                    clone.setAttribute(i, this.attributes[i]);
                    continue;
                }
                catch (IllegalAttributeException e1) {
                    throw new RuntimeException("The impossible has happened", e1);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("The impossible has happened", e);
        }
    }

    public String toString() {
        String retString = "Feature[ id=" + this.getID() + " , ";
        FeatureType featType = this.getFeatureType();
        int n = this.attributes.length;
        for (int i = 0; i < n; ++i) {
            retString = retString + featType.getAttributeType(i).getName() + "=";
            retString = retString + this.attributes[i];
            if (i + 1 >= n) continue;
            retString = retString + " , ";
        }
        retString = retString + " ]";
        return retString;
    }

    public int hashCode() {
        return this.featureId.hashCode() * this.schema.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Feature)) {
            return false;
        }
        Feature feat = (Feature)obj;
        if (!feat.getFeatureType().equals(this.schema)) {
            return false;
        }
        if (this.featureId == null && feat.getID() != null) {
            return false;
        }
        if (!this.featureId.equals(feat.getID())) {
            return false;
        }
        int ii = this.attributes.length;
        for (int i = 0; i < ii; ++i) {
            Object otherAtt = feat.getAttribute(i);
            if (this.attributes[i] == null) {
                if (otherAtt == null) continue;
                return false;
            }
            if (this.attributes[i].equals(otherAtt)) continue;
            if (this.attributes[i] instanceof Geometry && otherAtt instanceof Geometry) {
                if (((Geometry)this.attributes[i]).equals((Geometry)otherAtt)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public FeatureCollection getParent() {
        return this.parent;
    }

    public void setParent(FeatureCollection collection) {
        if (this.parent == null) {
            this.parent = collection;
        }
    }
}

