/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;

public class AttributeExpressionImpl
extends DefaultExpression
implements AttributeExpression {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    protected String attPath;
    protected FeatureType schema = null;

    protected AttributeExpressionImpl(FeatureType schema) {
        this.schema = schema;
        this.expressionType = (short)113;
    }

    protected AttributeExpressionImpl(FeatureType schema, String attPath) throws IllegalFilterException {
        this.schema = schema;
        this.expressionType = (short)113;
        this.setAttributePath(attPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttributePath(String attPath) throws IllegalFilterException {
        LOGGER.entering("ExpressionAttribute", "setAttributePath", attPath);
        LOGGER.finest("schema: " + this.schema + "\n\nattribute: " + attPath);
        if (this.schema != null) {
            if (!this.schema.hasAttributeType(attPath)) throw new IllegalFilterException("Attribute does not conform to stated schema.");
            this.attPath = attPath;
            return;
        } else {
            this.attPath = attPath;
        }
    }

    public String getAttributePath() {
        return this.attPath;
    }

    public Object getValue(Feature feature) {
        return feature.getAttribute(this.attPath);
    }

    public String toString() {
        return this.attPath;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            AttributeExpressionImpl expAttr = (AttributeExpressionImpl)obj;
            boolean isEqual = expAttr.getType() == this.expressionType;
            LOGGER.finest("expression type match:" + isEqual + "; in:" + expAttr.getType() + "; out:" + this.expressionType);
            isEqual = expAttr.attPath != null ? isEqual && expAttr.attPath.equals(this.attPath) : isEqual && this.attPath == null;
            LOGGER.finest("attribute match:" + isEqual + "; in:" + expAttr.getAttributePath() + "; out:" + this.attPath);
            isEqual = expAttr.schema != null ? isEqual && expAttr.schema.equals(this.schema) : isEqual && this.schema == null;
            LOGGER.finest("schema match:" + isEqual + "; in:" + expAttr.schema + "; out:" + this.schema);
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attPath == null ? 0 : this.attPath.hashCode());
        result = 37 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }
}

