/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.MathExpression;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ExpressionDOMParser {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter");
    private static final FilterFactory FILTER_FACT = FilterFactory.createFilterFactory();
    private static GeometryFactory gfac = new GeometryFactory();
    private static final int GML_BOX = 1;
    private static final int GML_POLYGON = 2;
    private static final int GML_LINESTRING = 3;
    private static final int GML_POINT = 4;
    private static final int NUM_BOX_COORDS = 5;

    private ExpressionDOMParser() {
    }

    public static Expression parseExpression(Node root) {
        MathExpression math;
        String childName;
        LOGGER.finer("parsingExpression " + root.getLocalName());
        if (root == null || root.getNodeType() != 1) {
            LOGGER.finer("bad node input ");
            return null;
        }
        LOGGER.finer("processing root " + root.getLocalName());
        Node child = root;
        String string = childName = child.getLocalName() != null ? child.getLocalName() : child.getNodeName();
        if (childName.equalsIgnoreCase("Literal")) {
            LOGGER.finer("processing literal " + child);
            NodeList kidList = child.getChildNodes();
            LOGGER.finest("literal elements (" + kidList.getLength() + ") " + kidList.toString());
            for (int i = 0; i < kidList.getLength(); ++i) {
                Node kid = kidList.item(i);
                LOGGER.finest("kid " + i + " " + kid);
                if (kid == null) {
                    LOGGER.finest("Skipping ");
                    continue;
                }
                if (kid.getNodeValue() == null) {
                    LOGGER.finer("node " + kid.getNodeValue() + " namespace " + kid.getNamespaceURI());
                    LOGGER.fine("a literal gml string?");
                    try {
                        Geometry geom = ExpressionDOMParser.parseGML(kid);
                        if (geom != null) {
                            LOGGER.finer("built a " + geom.getGeometryType() + " from gml");
                            LOGGER.finer("\tpoints: " + geom.getNumPoints());
                        } else {
                            LOGGER.finer("got a null geometry back from gml parser");
                        }
                        return FILTER_FACT.createLiteralExpression(geom);
                    }
                    catch (IllegalFilterException ife) {
                        LOGGER.warning("Problem building GML/JTS object: " + ife);
                        return null;
                    }
                }
                if (kid.getNodeValue().trim().length() == 0) {
                    LOGGER.finest("empty text element");
                    continue;
                }
                String nodeValue = kid.getNodeValue();
                LOGGER.finer("processing " + nodeValue);
                try {
                    try {
                        Integer intLit = new Integer(nodeValue);
                        LOGGER.finer("An integer");
                        return FILTER_FACT.createLiteralExpression(intLit);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Double doubleLit = new Double(nodeValue);
                            LOGGER.finer("A double");
                            return FILTER_FACT.createLiteralExpression(doubleLit);
                        }
                        catch (NumberFormatException e2) {
                            LOGGER.finer("defaulting to string");
                            return FILTER_FACT.createLiteralExpression(nodeValue);
                        }
                    }
                }
                catch (IllegalFilterException ife) {
                    LOGGER.finer("Unable to build expression " + ife);
                    return null;
                }
            }
        }
        if (childName.equalsIgnoreCase("add")) {
            try {
                LOGGER.fine("processing an Add");
                math = FILTER_FACT.createMathExpression((short)105);
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + value + "<-");
                math.addLeftValue(ExpressionDOMParser.parseExpression(value));
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + value + "<-");
                math.addRightValue(ExpressionDOMParser.parseExpression(value));
                return math;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + ife);
                return null;
            }
        }
        if (childName.equalsIgnoreCase("sub")) {
            try {
                math = FILTER_FACT.createMathExpression((short)106);
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + value + "<-");
                math.addLeftValue(ExpressionDOMParser.parseExpression(value));
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + value + "<-");
                math.addRightValue(ExpressionDOMParser.parseExpression(value));
                return math;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + ife);
                return null;
            }
        }
        if (childName.equalsIgnoreCase("mul")) {
            try {
                math = FILTER_FACT.createMathExpression((short)107);
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + value + "<-");
                math.addLeftValue(ExpressionDOMParser.parseExpression(value));
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + value + "<-");
                math.addRightValue(ExpressionDOMParser.parseExpression(value));
                return math;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + ife);
                return null;
            }
        }
        if (childName.equalsIgnoreCase("div")) {
            try {
                math = FILTER_FACT.createMathExpression((short)108);
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + value + "<-");
                math.addLeftValue(ExpressionDOMParser.parseExpression(value));
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + value + "<-");
                math.addRightValue(ExpressionDOMParser.parseExpression(value));
                return math;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + ife);
                return null;
            }
        }
        if (childName.equalsIgnoreCase("PropertyName")) {
            try {
                AttributeExpression attribute = FILTER_FACT.createAttributeExpression(null);
                attribute.setAttributePath(child.getFirstChild().getNodeValue());
                return attribute;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression: " + ife);
                return null;
            }
        }
        if (childName.equalsIgnoreCase("Function")) {
            FunctionExpression func = null;
            Element param = (Element)child;
            NamedNodeMap map = param.getAttributes();
            for (int k = 0; k < map.getLength(); ++k) {
                String res = map.item(k).getNodeValue();
                String name = map.item(k).getLocalName();
                if (name == null) {
                    name = map.item(k).getNodeName();
                }
                LOGGER.fine("attribute " + name + " with value of " + res);
                if (!name.equalsIgnoreCase("name")) continue;
                func = FILTER_FACT.createFunctionExpression(res);
            }
            if (func == null) {
                LOGGER.severe("failed to find function in " + child);
                return null;
            }
            int argCount = func.getArgCount();
            Expression[] args = new Expression[argCount];
            Node value = child.getFirstChild();
            for (int i = 0; i < argCount; ++i) {
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                args[i] = ExpressionDOMParser.parseExpression(value);
                value = value.getNextSibling();
            }
            func.setArgs(args);
            return func;
        }
        if (child.getNodeType() == 3) {
            LOGGER.finer("processing a text node " + root.getNodeValue());
            String nodeValue = root.getNodeValue();
            LOGGER.finer("Text name " + nodeValue);
            try {
                try {
                    Integer intLiteral = new Integer(nodeValue);
                    return FILTER_FACT.createLiteralExpression(intLiteral);
                }
                catch (NumberFormatException e) {
                    try {
                        Double doubleLit = new Double(nodeValue);
                        return FILTER_FACT.createLiteralExpression(doubleLit);
                    }
                    catch (NumberFormatException e3) {
                        return FILTER_FACT.createLiteralExpression(nodeValue);
                    }
                }
            }
            catch (IllegalFilterException ife) {
                LOGGER.finer("Unable to build expression " + ife);
            }
        }
        return null;
    }

    public static Geometry parseGML(Node root) {
        String childName;
        LOGGER.finer("processing gml " + root);
        int type = 0;
        Node child = root;
        String string = childName = child.getLocalName() != null ? child.getLocalName() : child.getNodeName();
        if (childName.equalsIgnoreCase("gml:box")) {
            LOGGER.finer("box");
            type = 1;
            List coordList = ExpressionDOMParser.parseCoords(child);
            Envelope env = new Envelope();
            for (int i = 0; i < coordList.size(); ++i) {
                env.expandToInclude((Coordinate)coordList.get(i));
            }
            Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
            LinearRing ring = null;
            try {
                ring = gfac.createLinearRing(coords);
            }
            catch (TopologyException tope) {
                LOGGER.fine("Topology Exception in GMLBox" + tope);
                return null;
            }
            return gfac.createPolygon(ring, null);
        }
        if (childName.equalsIgnoreCase("gml:polygon")) {
            LOGGER.finer("polygon");
            type = 2;
            LinearRing outer = null;
            ArrayList<LinearRing> inner = new ArrayList<LinearRing>();
            NodeList kids = root.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                String kidName;
                Node kid = kids.item(i);
                LOGGER.finer("doing " + kid);
                String string2 = kidName = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                if (kidName.equalsIgnoreCase("gml:outerBoundaryIs")) {
                    outer = (LinearRing)ExpressionDOMParser.parseGML(kid);
                }
                if (!kidName.equalsIgnoreCase("gml:innerBoundaryIs")) continue;
                inner.add((LinearRing)ExpressionDOMParser.parseGML(kid));
            }
            if (inner.size() > 0) {
                return gfac.createPolygon(outer, inner.toArray(new LinearRing[0]));
            }
            return gfac.createPolygon(outer, null);
        }
        if (childName.equalsIgnoreCase("gml:outerBoundaryIs") || childName.equalsIgnoreCase("gml:innerBoundaryIs")) {
            LOGGER.finer("Boundary layer");
            NodeList kids = ((Element)child).getElementsByTagName("gml:LinearRing");
            return ExpressionDOMParser.parseGML(kids.item(0));
        }
        if (childName.equalsIgnoreCase("gml:linearRing")) {
            LOGGER.finer("LinearRing");
            List coordList = ExpressionDOMParser.parseCoords(child);
            LinearRing ring = null;
            try {
                ring = gfac.createLinearRing(coordList.toArray(new Coordinate[0]));
            }
            catch (TopologyException te) {
                LOGGER.finer("Topology Exception build linear ring: " + te);
                return null;
            }
            return ring;
        }
        if (childName.equalsIgnoreCase("gml:linestring")) {
            LOGGER.finer("linestring");
            type = 3;
            List coordList = ExpressionDOMParser.parseCoords(child);
            LineString line = null;
            line = gfac.createLineString(coordList.toArray(new Coordinate[0]));
            return line;
        }
        if (childName.equalsIgnoreCase("gml:point")) {
            LOGGER.finer("point");
            type = 4;
            List coordList = ExpressionDOMParser.parseCoords(child);
            Point point = null;
            point = gfac.createPoint((Coordinate)coordList.get(0));
            return point;
        }
        if (childName.toLowerCase().startsWith("gml:multiPolygon")) {
            LOGGER.finer("MultiPolygon");
            ArrayList<Geometry> multi = new ArrayList<Geometry>();
            NodeList kids = child.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                multi.add(ExpressionDOMParser.parseGML(kids.item(i)));
            }
            return gfac.createMultiPolygon(multi.toArray(new Polygon[0]));
        }
        return null;
    }

    public static List parseCoords(Node root) {
        LOGGER.finer("parsing coordinate(s) " + root);
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>();
        NodeList kids = root.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            String childName;
            Node child = kids.item(i);
            LOGGER.finer("doing " + child);
            String string = childName = child.getLocalName() != null ? child.getLocalName() : child.getNodeName();
            if (!childName.equalsIgnoreCase("gml:coordinates")) continue;
            LOGGER.finer("coordinates " + child.getFirstChild().getNodeValue());
            NodeList grandKids = child.getChildNodes();
            for (int k = 0; k < grandKids.getLength(); ++k) {
                Node grandKid = grandKids.item(k);
                if (grandKid.getNodeValue() == null || grandKid.getNodeValue().trim().length() == 0) continue;
                String outer = grandKid.getNodeValue().trim();
                StringTokenizer ost = new StringTokenizer(outer, " ");
                while (ost.hasMoreTokens()) {
                    String internal = ost.nextToken();
                    StringTokenizer ist = new StringTokenizer(internal, ",");
                    double xCoord = Double.parseDouble(ist.nextToken());
                    double yCoord = Double.parseDouble(ist.nextToken());
                    double zCoord = Double.NaN;
                    if (ist.hasMoreTokens()) {
                        zCoord = Double.parseDouble(ist.nextToken());
                    }
                    clist.add(new Coordinate(xCoord, yCoord, zCoord));
                }
            }
        }
        return clist;
    }
}

