/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.ExpressionSAXParser;
import org.geotools.filter.FilterHandler;
import org.geotools.filter.FilterSAXParser;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LogicSAXParser;
import org.geotools.gml.GMLHandlerJTS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class FilterFilter
extends XMLFilterImpl
implements GMLHandlerJTS {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter");
    private LogicSAXParser logicFactory;
    private FilterSAXParser filterFactory;
    private ExpressionSAXParser expressionFactory;
    private FilterHandler parent;
    private FeatureType schema;
    private boolean isLogicFilter = false;
    private boolean isFidFilter = false;
    protected boolean insideFilter = false;
    private boolean insideDistance = false;
    private String units;

    public FilterFilter(FilterHandler parent, FeatureType schema) {
        this.parent = parent;
        this.schema = schema;
        this.expressionFactory = new ExpressionSAXParser(schema);
        this.filterFactory = new FilterSAXParser();
        this.logicFactory = new LogicSAXParser();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        LOGGER.finer("found start element: " + localName);
        if (localName.equals("Filter")) {
            this.insideFilter = true;
            return;
        } else if (this.insideFilter) {
            short filterType = FilterFilter.convertType(localName);
            LOGGER.finest("types: (xml): " + localName + "; " + "(internal): " + filterType);
            try {
                if (this.isFidFilter) {
                    if (filterType == 22) {
                        LOGGER.finer("sending attributes to existing FID filter");
                        this.filterFactory.setAttributes(atts);
                    } else {
                        this.isFidFilter = false;
                        LOGGER.finer("is fid (1): " + this.isFidFilter);
                        if (this.isLogicFilter) {
                            this.logicFactory.add(this.filterFactory.create());
                        } else {
                            this.parent.filter(this.filterFactory.create());
                        }
                    }
                }
                if (this.isFidFilter) return;
                LOGGER.finest("is logic?");
                if (AbstractFilter.isLogicFilter(filterType)) {
                    LOGGER.finer("found a logic filter start");
                    this.isLogicFilter = true;
                    this.logicFactory.start(filterType);
                    return;
                }
                if (AbstractFilter.isSimpleFilter(filterType)) {
                    LOGGER.finer("found a simple filter start");
                    this.filterFactory.start(filterType);
                    if (filterType == 20) {
                        LOGGER.finer("sending attributes for like filter");
                        this.filterFactory.setAttributes(atts);
                        return;
                    }
                    if (filterType != 22) return;
                    LOGGER.finer("sending attributes to new FID filter");
                    this.filterFactory.setAttributes(atts);
                    this.isFidFilter = true;
                    LOGGER.finer("is fid (3): " + this.isFidFilter);
                    return;
                }
                if (DefaultExpression.isExpression(filterType)) {
                    LOGGER.finest("found an expression filter start");
                    this.expressionFactory.start(localName);
                    return;
                }
                if (!localName.equals("Distance")) return;
                LOGGER.finest("inside distance");
                if ("units".equals(atts.getLocalName(0))) {
                    this.units = atts.getValue(0);
                    LOGGER.finest("units = " + this.units);
                }
                this.insideDistance = true;
                return;
            }
            catch (IllegalFilterException ife) {
                throw new SAXException("Attempted to construct illegal filter: " + ife.getMessage(), ife);
            }
        } else {
            this.parent.startElement(namespaceURI, localName, qName, atts);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        String message = new String(chars, start, length);
        if (this.insideFilter) {
            try {
                if (this.insideDistance) {
                    LOGGER.finest("calling set distance on " + message + ", " + this.units);
                    this.filterFactory.setDistance(message, this.units);
                }
                LOGGER.finest("sending to expression factory: " + message);
                this.expressionFactory.message(message);
            }
            catch (IllegalFilterException ife) {
                throw new SAXException(ife);
            }
        } else {
            this.parent.characters(chars, start, length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        LOGGER.finer("found start element: " + localName);
        if (localName.equals("Filter")) {
            if (this.isFidFilter && !localName.equals("FeatureId")) {
                this.isFidFilter = false;
                LOGGER.finer("is fid (2): " + this.isFidFilter);
                try {
                    if (this.isLogicFilter) {
                        this.logicFactory.add(this.filterFactory.create());
                    } else {
                        this.parent.filter(this.filterFactory.create());
                    }
                }
                catch (IllegalFilterException e) {
                    throw new SAXException("Attempted to construct illegal filter: " + e.getMessage());
                }
            }
            this.insideFilter = false;
            return;
        }
        if (this.insideFilter) {
            short filterType = FilterFilter.convertType(localName);
            try {
                if (AbstractFilter.isLogicFilter(filterType)) {
                    LOGGER.finest("found a logic filter end");
                    if (this.isFidFilter) {
                        this.logicFactory.add(this.filterFactory.create());
                        this.isFidFilter = false;
                    }
                    this.logicFactory.end(filterType);
                    if (!this.logicFactory.isComplete()) return;
                    LOGGER.finer("creating logic factory");
                    this.parent.filter(this.logicFactory.create());
                    return;
                }
                if (AbstractFilter.isSimpleFilter(filterType) && !this.isFidFilter) {
                    LOGGER.finest("found a simple filter end");
                    if (this.isLogicFilter) {
                        this.logicFactory.add(this.filterFactory.create());
                        return;
                    }
                    this.parent.filter(this.filterFactory.create());
                    return;
                }
                if (DefaultExpression.isExpression(filterType)) {
                    LOGGER.finer("found an expression filter end");
                    this.expressionFactory.end(localName);
                    if (!this.expressionFactory.isReady()) return;
                    LOGGER.finer("expression factory is ready");
                    this.filterFactory.expression(this.expressionFactory.create());
                    return;
                }
                if (!localName.equals("Distance")) return;
                this.insideDistance = false;
                return;
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Attempted to construct illegal filter: " + e.getMessage());
            }
        } else {
            this.parent.endElement(namespaceURI, localName, qName);
        }
    }

    public void geometry(Geometry geometry) throws RuntimeException {
        try {
            LOGGER.finer("got geometry: " + geometry);
            this.expressionFactory.geometry(geometry);
            if (this.expressionFactory.isReady()) {
                LOGGER.finer("expression factory made expression and sent to filter factory");
                this.filterFactory.expression(this.expressionFactory.create());
            }
        }
        catch (IllegalFilterException ife) {
            LOGGER.finer("Had problems adding geometry: " + geometry.toString());
            throw new RuntimeException("problem adding geometry to filter ", ife);
        }
    }

    protected static short convertType(String filterType) {
        if (filterType.equals("Or")) {
            return 1;
        }
        if (filterType.equals("And")) {
            return 2;
        }
        if (filterType.equals("Not")) {
            return 3;
        }
        if (filterType.equals("Equals")) {
            return 5;
        }
        if (filterType.equals("Disjoint")) {
            return 6;
        }
        if (filterType.equals("DWithin")) {
            return 24;
        }
        if (filterType.equals("Intersects")) {
            return 7;
        }
        if (filterType.equals("Touches")) {
            return 8;
        }
        if (filterType.equals("Crosses")) {
            return 9;
        }
        if (filterType.equals("Within")) {
            return 10;
        }
        if (filterType.equals("Contains")) {
            return 11;
        }
        if (filterType.equals("Overlaps")) {
            return 12;
        }
        if (filterType.equals("Beyond")) {
            return 13;
        }
        if (filterType.equals("BBOX")) {
            return 4;
        }
        if (filterType.equals("PropertyIsEqualTo")) {
            return 14;
        }
        if (filterType.equals("PropertyIsNotEqualTo")) {
            return 23;
        }
        if (filterType.equals("PropertyIsLessThan")) {
            return 15;
        }
        if (filterType.equals("PropertyIsGreaterThan")) {
            return 16;
        }
        if (filterType.equals("PropertyIsLessThanOrEqualTo")) {
            return 17;
        }
        if (filterType.equals("PropertyIsGreaterThanOrEqualTo")) {
            return 18;
        }
        if (filterType.equals("PropertyIsBetween")) {
            return 19;
        }
        if (filterType.equals("PropertyIsLike")) {
            return 20;
        }
        if (filterType.equals("PropertyIsNull")) {
            return 21;
        }
        if (filterType.equals("FeatureId")) {
            return 22;
        }
        if (filterType.equals("Add")) {
            return 105;
        }
        if (filterType.equals("Sub")) {
            return 106;
        }
        if (filterType.equals("Mul")) {
            return 107;
        }
        if (filterType.equals("Div")) {
            return 108;
        }
        if (filterType.equals("PropertyName")) {
            return 101;
        }
        if (filterType.equals("Literal")) {
            return 109;
        }
        return -1;
    }
}

