/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;

public class LikeFilterImpl
extends AbstractFilterImpl
implements LikeFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private Expression attribute = null;
    private String pattern = null;
    private String wildcardSingle = ".?";
    private String escapedWildcardSingle = "\\.\\?";
    private String wildcardMulti = ".*";
    private String escapedWildcardMulti = "\\.\\*";
    private String escape = "\\";
    private Pattern compPattern = null;
    private Matcher matcher = null;

    protected LikeFilterImpl() {
        this.filterType = (short)20;
    }

    public void setValue(Expression attribute) throws IllegalFilterException {
        if (attribute.getType() == 111 && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add something other than a string attribute expression to a like filter.");
        }
        this.attribute = attribute;
    }

    public Expression getValue() {
        return this.attribute;
    }

    public void setPattern(Expression p, String wildcardMulti, String wildcardSingle, String escape) {
        String pattern = p.toString();
        this.setPattern(pattern, wildcardMulti, wildcardSingle, escape);
    }

    public void setPattern(String pattern, String wildcardMulti, String wildcardSingle, String escape) {
        char esc = escape.charAt(0);
        LOGGER.finer("wildcard " + wildcardMulti + " single " + wildcardSingle);
        LOGGER.finer("escape " + escape + " esc " + esc + " esc == \\ " + (esc == '\\'));
        this.escapedWildcardMulti = this.fixSpecials(wildcardMulti);
        this.escapedWildcardSingle = this.fixSpecials(wildcardSingle);
        LOGGER.finer("after fixing: wildcard " + wildcardMulti + " single " + wildcardSingle + " escape " + escape);
        LOGGER.finer("start pattern = " + pattern);
        StringBuffer tmp = new StringBuffer("");
        boolean escapedMode = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            LOGGER.finer("tmp = " + tmp + " looking at " + chr);
            if (pattern.regionMatches(false, i, escape, 0, escape.length())) {
                LOGGER.finer("escape ");
                escapedMode = true;
                chr = pattern.charAt(i += escape.length());
            }
            if (pattern.regionMatches(false, i, wildcardMulti, 0, wildcardMulti.length())) {
                LOGGER.finer("multi wildcard");
                if (escapedMode) {
                    LOGGER.finer("escaped ");
                    tmp.append(this.escapedWildcardMulti);
                } else {
                    tmp.append(this.wildcardMulti);
                }
                i += wildcardMulti.length() - 1;
                escapedMode = false;
                continue;
            }
            if (pattern.regionMatches(false, i, wildcardSingle, 0, wildcardSingle.length())) {
                LOGGER.finer("single wildcard");
                if (escapedMode) {
                    LOGGER.finer("escaped ");
                    tmp.append(this.escapedWildcardSingle);
                } else {
                    tmp.append(this.wildcardSingle);
                }
                i += wildcardSingle.length() - 1;
                escapedMode = false;
                continue;
            }
            if (this.isSpecial(chr)) {
                LOGGER.finer("special");
                tmp.append(this.escape + chr);
                escapedMode = false;
                continue;
            }
            tmp.append(chr);
            escapedMode = false;
        }
        this.pattern = tmp.toString();
        LOGGER.finer("final pattern " + this.pattern);
        this.compPattern = Pattern.compile(this.pattern);
        this.matcher = this.compPattern.matcher("");
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean contains(Feature feature) {
        if (this.attribute == null) {
            return false;
        }
        Object value = this.attribute.getValue(feature);
        if (null == value) {
            return false;
        }
        this.matcher.reset(this.attribute.getValue(feature).toString());
        return this.matcher.matches();
    }

    public String toString() {
        return "[ " + this.attribute.toString() + " is like " + this.pattern + " ]";
    }

    public String getEscape() {
        return this.escape;
    }

    public String getWildcardMulti() {
        return this.wildcardMulti;
    }

    public String getWildcardSingle() {
        return this.wildcardSingle;
    }

    private boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\' || chr == '&';
    }

    private String fixSpecials(String inString) {
        StringBuffer tmp = new StringBuffer("");
        for (int i = 0; i < inString.length(); ++i) {
            char chr = inString.charAt(i);
            if (this.isSpecial(chr)) {
                tmp.append(this.escape + chr);
                continue;
            }
            tmp.append(chr);
        }
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LikeFilterImpl) {
            LikeFilterImpl lFilter = (LikeFilterImpl)obj;
            return lFilter.getFilterType() == this.filterType && lFilter.getValue().equals(this.attribute) && lFilter.getPattern().equals(this.pattern);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 37 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }
}

