/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.image.RenderedImage;
import org.geotools.ct.MathTransform1D;
import org.geotools.cv.SampleDimension;
import org.geotools.gc.GridCoverage;
import org.geotools.gc.GridGeometry;
import org.geotools.gc.GridRange;
import org.geotools.gc.InvalidGridGeometryException;
import org.geotools.pt.Envelope;

public final class LegacyGCSUtilities {
    private LegacyGCSUtilities() {
    }

    public static boolean hasGridRange(GridGeometry geometry) {
        if (geometry != null) {
            try {
                geometry.getGridRange();
                return true;
            }
            catch (InvalidGridGeometryException invalidGridGeometryException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasTransform(GridGeometry geometry) {
        if (geometry != null) {
            try {
                geometry.getGridToCoordinateSystem();
                return true;
            }
            catch (InvalidGridGeometryException invalidGridGeometryException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Envelope toEnvelope(GridRange gridRange) {
        int dimension = gridRange.getDimension();
        double[] lower = new double[dimension];
        double[] upper = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = gridRange.getLower(i);
            upper[i] = gridRange.getUpper(i);
        }
        return new Envelope(lower, upper);
    }

    public static GridRange toGridRange(Envelope envelope) {
        int dimension = envelope.getDimension();
        int[] lower = new int[dimension];
        int[] upper = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = (int)Math.round(envelope.getMinimum(i));
            upper[i] = (int)Math.round(envelope.getMaximum(i));
        }
        return new GridRange(lower, upper);
    }

    public static boolean hasTransform(SampleDimension[] sampleDimensions) {
        int i = sampleDimensions.length;
        while (--i >= 0) {
            MathTransform1D tr = sampleDimensions[i].geophysics(false).getSampleToGeophysics();
            if (tr == null || tr.isIdentity()) continue;
            return true;
        }
        return false;
    }

    public static boolean uses(GridCoverage coverage, RenderedImage image) {
        if (coverage != null) {
            if (coverage.getRenderedImage() == image) {
                return true;
            }
            GridCoverage[] sources = coverage.getSources();
            if (sources != null) {
                for (int i = 0; i < sources.length; ++i) {
                    if (!LegacyGCSUtilities.uses(sources[i], image)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getVisibleBand(RenderedImage image) {
        Object candidate = image.getProperty("GC_VisibleBand");
        if (candidate instanceof Integer) {
            return (Integer)candidate;
        }
        return 0;
    }
}

