/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.resources.Utilities;
import org.geotools.resources.WKTFormat;
import org.geotools.resources.XArray;
import org.geotools.resources.cts.Resources;

public final class WKTElement {
    private final int offset;
    public final String keyword;
    private final List list;

    WKTElement(WKTElement singleton) {
        this.offset = 0;
        this.keyword = null;
        this.list = new LinkedList();
        this.list.add(singleton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WKTElement(WKTFormat format, String text, ParsePosition position) throws ParseException {
        int upper;
        int lower;
        int length = text.length();
        for (lower = position.getIndex(); lower < length && Character.isSpaceChar(text.charAt(lower)); ++lower) {
        }
        this.offset = lower;
        for (upper = lower; upper < length && Character.isUnicodeIdentifierPart(text.charAt(upper)); ++upper) {
        }
        if (upper <= lower) {
            position.setErrorIndex(lower);
            throw this.unparsableString(text, position);
        }
        this.keyword = text.substring(lower, upper).toUpperCase(format.locale);
        position.setIndex(upper);
        int bracketIndex = -1;
        do {
            if (++bracketIndex < format.openingBrackets.length) continue;
            this.list = null;
            return;
        } while (!WKTElement.parseOptionalSeparator(text, position, format.openingBrackets[bracketIndex]));
        this.list = new LinkedList();
        do {
            if (position.getIndex() >= length) {
                throw this.missingCharacter(format.closingBracket, length);
            }
            if (WKTElement.parseOptionalSeparator(text, position, format.textDelimitor)) {
                lower = position.getIndex();
                upper = text.indexOf(format.textDelimitor, lower);
                if (upper < lower) {
                    position.setErrorIndex(++lower);
                    throw this.missingCharacter(format.textDelimitor, lower);
                }
                this.list.add(text.substring(lower, upper).trim());
                position.setIndex(upper + 1);
                continue;
            }
            lower = position.getIndex();
            if (!Character.isUnicodeIdentifierStart(text.charAt(lower))) {
                Number number;
                NumberFormat numberFormat = format.number;
                synchronized (numberFormat) {
                    number = format.number.parse(text, position);
                }
                if (number == null) {
                    throw this.unparsableString(text, position);
                }
                this.list.add(number);
                continue;
            }
            this.list.add(new WKTElement(format, text, position));
        } while (WKTElement.parseOptionalSeparator(text, position, format.elementSeparator));
        this.parseSeparator(text, position, format.closingBrackets[bracketIndex]);
    }

    private static boolean parseOptionalSeparator(String text, ParsePosition position, char separator) {
        int index;
        int length = text.length();
        for (index = position.getIndex(); index < length; ++index) {
            char c = text.charAt(index);
            if (Character.isSpaceChar(c)) {
                continue;
            }
            if (c != separator) break;
            position.setIndex(++index);
            return true;
        }
        position.setIndex(index);
        return false;
    }

    private void parseSeparator(String text, ParsePosition position, char separator) throws ParseException {
        if (!WKTElement.parseOptionalSeparator(text, position, separator)) {
            position.setErrorIndex(position.getIndex());
            throw this.unparsableString(text, position);
        }
    }

    public ParseException parseFailed(Exception cause, String message) {
        if (message == null) {
            message = cause.getLocalizedMessage();
        }
        ParseException exception = new ParseException(this.complete(message), this.offset);
        exception = WKTElement.trim("parseFailed", exception);
        exception.initCause(cause);
        return exception;
    }

    private ParseException unparsableString(String text, ParsePosition position) {
        int length;
        int lower = position.getErrorIndex();
        int upper = lower;
        if (upper < (length = text.length())) {
            int type = Character.getType(text.charAt(upper));
            while (++upper < length && Character.getType(text.charAt(upper)) == type) {
            }
        }
        return WKTElement.trim("unparsableString", new ParseException(this.complete(Resources.format(116, text.substring(position.getIndex()), text.substring(lower, upper))), lower));
    }

    private ParseException missingCharacter(char c, int position) {
        return WKTElement.trim("missingCharacter", new ParseException(this.complete(Resources.format(93, new Character(c))), position));
    }

    private ParseException missingParameter(String key) {
        return WKTElement.trim("missingParameter", new ParseException(this.complete(Resources.format(94, key)), this.offset + this.keyword.length()));
    }

    private String complete(String message) {
        if (this.keyword != null) {
            message = Resources.format(87, this.keyword) + ' ' + message;
        }
        return message;
    }

    private static ParseException trim(String factory, ParseException exception) {
        Object[] trace = exception.getStackTrace();
        if (trace != null && trace.length != 0 && factory.equals(trace[0].getMethodName())) {
            trace = (StackTraceElement[])XArray.remove(trace, 0, 1);
            exception.setStackTrace((StackTraceElement[])trace);
        }
        return exception;
    }

    public double pullDouble(String key) throws ParseException {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingParameter(key);
    }

    public int pullInteger(String key) throws ParseException {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new ParseException(this.complete(Resources.format(77, key, number)), this.offset);
            }
            return number.intValue();
        }
        throw this.missingParameter(key);
    }

    public String pullString(String key) throws ParseException {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        throw this.missingParameter(key);
    }

    public WKTElement pullElement(String key) throws ParseException {
        WKTElement element = this.pullOptionalElement(key);
        if (element != null) {
            return element;
        }
        throw this.missingParameter(key);
    }

    public WKTElement pullOptionalElement(String key) {
        key = key.toUpperCase();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof WKTElement)) continue;
            WKTElement element = (WKTElement)object;
            if (element.list == null || !element.keyword.equals(key)) continue;
            iterator.remove();
            return element;
        }
        return null;
    }

    public WKTElement pullVoidElement(String key) throws ParseException {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof WKTElement)) continue;
            WKTElement element = (WKTElement)object;
            if (element.list != null) continue;
            iterator.remove();
            return element;
        }
        throw this.missingParameter(key);
    }

    public Object peek() {
        return this.list.isEmpty() ? null : this.list.get(0);
    }

    public void close() throws ParseException {
        if (this.list != null && !this.list.isEmpty()) {
            throw new ParseException(this.complete(Resources.format(112, this.list.get(0))), this.offset + this.keyword.length());
        }
    }

    public String toString() {
        return this.keyword;
    }

    public void print(PrintWriter out, int level) {
        int tabWidth = 4;
        out.print(Utilities.spaces(4 * level));
        out.println(this.keyword);
        if (this.list == null) {
            return;
        }
        int size = this.list.size();
        for (int j = 0; j < size; ++j) {
            Object object = this.list.get(j);
            if (object instanceof WKTElement) {
                ((WKTElement)object).print(out, level + 1);
                continue;
            }
            out.print(Utilities.spaces(4 * (level + 1)));
            out.println(object);
        }
    }
}

