/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.geometry;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import org.geotools.resources.Utilities;

public class XRectangle2D
extends Rectangle2D
implements Serializable {
    private static final double EPS = 1.0E-6;
    public static final Rectangle2D INFINITY = new Infinite();
    private static final long serialVersionUID = -1918221103635749436L;
    protected double xmin;
    protected double ymin;
    protected double xmax;
    protected double ymax;

    public XRectangle2D() {
    }

    public XRectangle2D(double x, double y, double width, double height) {
        this.xmin = x;
        this.ymin = y;
        this.xmax = x + width;
        this.ymax = y + height;
    }

    public XRectangle2D(Rectangle2D rect) {
        if (rect != null) {
            this.setRect(rect);
        }
    }

    public static XRectangle2D createFromExtremums(double xmin, double ymin, double xmax, double ymax) {
        XRectangle2D rect = new XRectangle2D();
        rect.xmin = xmin;
        rect.ymin = ymin;
        rect.xmax = xmax;
        rect.ymax = ymax;
        return rect;
    }

    public boolean isEmpty() {
        return !(this.xmin < this.xmax) || !(this.ymin < this.ymax);
    }

    public double getX() {
        return this.xmin;
    }

    public double getY() {
        return this.ymin;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public double getMinX() {
        return this.xmin;
    }

    public double getMinY() {
        return this.ymin;
    }

    public double getMaxX() {
        return this.xmax;
    }

    public double getMaxY() {
        return this.ymax;
    }

    public double getCenterX() {
        return (this.xmin + this.xmax) * 0.5;
    }

    public double getCenterY() {
        return (this.ymin + this.ymax) * 0.5;
    }

    public void setRect(double x, double y, double width, double height) {
        this.xmin = x;
        this.ymin = y;
        this.xmax = x + width;
        this.ymax = y + height;
    }

    public void setRect(Rectangle2D r) {
        this.xmin = r.getMinX();
        this.ymin = r.getMinY();
        this.xmax = r.getMaxX();
        this.ymax = r.getMaxY();
    }

    public boolean intersects(double x, double y, double width, double height) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && width > 0.0 && height > 0.0)) {
            return false;
        }
        return x < this.xmax && y < this.ymax && x + width > this.xmin && y + height > this.ymin;
    }

    public boolean intersects(Rectangle2D rect) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double xmin2 = rect.getMinX();
        double xmax2 = rect.getMaxX();
        if (!(xmax2 > xmin2)) {
            return false;
        }
        double ymin2 = rect.getMinY();
        double ymax2 = rect.getMaxY();
        if (!(ymax2 > ymin2)) {
            return false;
        }
        return xmin2 < this.xmax && ymin2 < this.ymax && xmax2 > this.xmin && ymax2 > this.ymin;
    }

    public static boolean intersectInclusive(Rectangle2D rect1, Rectangle2D rect2) {
        double xmin1 = rect1.getMinX();
        double xmax1 = rect1.getMaxX();
        if (!(xmax1 >= xmin1)) {
            return false;
        }
        double ymin1 = rect1.getMinY();
        double ymax1 = rect1.getMaxY();
        if (!(ymax1 >= ymin1)) {
            return false;
        }
        double xmin2 = rect2.getMinX();
        double xmax2 = rect2.getMaxX();
        if (!(xmax2 >= xmin2)) {
            return false;
        }
        double ymin2 = rect2.getMinY();
        double ymax2 = rect2.getMaxY();
        if (!(ymax2 >= ymin2)) {
            return false;
        }
        return xmax2 >= xmin1 && ymax2 >= ymin1 && xmin2 <= xmax1 && ymin2 <= ymax1;
    }

    public static boolean intersectInclusive(Shape shape, Rectangle2D rect) {
        double x = rect.getX();
        double y = rect.getY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        if (width == 0.0 && height == 0.0) {
            width = 1.0E-6;
            height = 1.0E-6;
        } else if (width == 0.0) {
            width = height * 1.0E-6;
            x -= 0.5 * width;
        } else if (height == 0.0) {
            height = width * 1.0E-6;
            y -= 0.5 * height;
        }
        return shape.intersects(x, y, width, height);
    }

    public boolean contains(double x, double y, double width, double height) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && width > 0.0 && height > 0.0)) {
            return false;
        }
        return x >= this.xmin && y >= this.ymin && x + width <= this.xmax && y + height <= this.ymax;
    }

    public boolean contains(Rectangle2D rect) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double xmin2 = rect.getMinX();
        double xmax2 = rect.getMaxX();
        if (!(xmax2 > xmin2)) {
            return false;
        }
        double ymin2 = rect.getMinY();
        double ymax2 = rect.getMaxY();
        if (!(ymax2 > ymin2)) {
            return false;
        }
        return xmin2 >= this.xmin && ymin2 >= this.ymin && xmax2 <= this.xmax && ymax2 <= this.ymax;
    }

    public boolean contains(double x, double y) {
        return x >= this.xmin && y >= this.ymin && x < this.xmax && y < this.ymax;
    }

    public int outcode(double x, double y) {
        int out = 0;
        if (!(this.xmax > this.xmin)) {
            out |= 5;
        } else if (x < this.xmin) {
            out |= 1;
        } else if (x > this.xmax) {
            out |= 4;
        }
        if (!(this.ymax > this.ymin)) {
            out |= 0xA;
        } else if (y < this.ymin) {
            out |= 2;
        } else if (y > this.ymax) {
            out |= 8;
        }
        return out;
    }

    public Rectangle2D createIntersection(Rectangle2D rect) {
        XRectangle2D r = new XRectangle2D();
        r.xmin = Math.max(this.xmin, rect.getMinX());
        r.ymin = Math.max(this.ymin, rect.getMinY());
        r.xmax = Math.min(this.xmax, rect.getMaxX());
        r.ymax = Math.min(this.ymax, rect.getMaxY());
        return r;
    }

    public Rectangle2D createUnion(Rectangle2D rect) {
        XRectangle2D r = new XRectangle2D();
        r.xmin = Math.min(this.xmin, rect.getMinX());
        r.ymin = Math.min(this.ymin, rect.getMinY());
        r.xmax = Math.max(this.xmax, rect.getMaxX());
        r.ymax = Math.max(this.ymax, rect.getMaxY());
        return r;
    }

    public void add(double x, double y) {
        if (x < this.xmin) {
            this.xmin = x;
        }
        if (x > this.xmax) {
            this.xmax = x;
        }
        if (y < this.ymin) {
            this.ymin = y;
        }
        if (y > this.ymax) {
            this.ymax = y;
        }
    }

    public void add(Rectangle2D rect) {
        double d;
        double d2;
        double d3;
        double d4;
        double t = rect.getMinX();
        if (d4 < this.xmin) {
            this.xmin = t;
        }
        t = rect.getMaxX();
        if (d3 > this.xmax) {
            this.xmax = t;
        }
        t = rect.getMinY();
        if (d2 < this.ymin) {
            this.ymin = t;
        }
        t = rect.getMaxY();
        if (d > this.ymax) {
            this.ymax = t;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        NumberFormat format = NumberFormat.getNumberInstance();
        FieldPosition dummy = new FieldPosition(0);
        buffer.append("[xmin=");
        format.format(this.xmin, buffer, dummy);
        buffer.append(" xmax=");
        format.format(this.xmax, buffer, dummy);
        buffer.append(" ymin=");
        format.format(this.ymin, buffer, dummy);
        buffer.append(" ymax=");
        format.format(this.ymax, buffer, dummy);
        buffer.append(']');
        return buffer.toString();
    }

    private static final class Infinite
    extends Rectangle2D
    implements Serializable {
        private static final long serialVersionUID = 5281254268988984523L;

        private Infinite() {
        }

        public double getX() {
            return Double.NEGATIVE_INFINITY;
        }

        public double getY() {
            return Double.NEGATIVE_INFINITY;
        }

        public double getMinX() {
            return Double.NEGATIVE_INFINITY;
        }

        public double getMinY() {
            return Double.NEGATIVE_INFINITY;
        }

        public double getMaxX() {
            return Double.POSITIVE_INFINITY;
        }

        public double getMaxY() {
            return Double.POSITIVE_INFINITY;
        }

        public double getWidth() {
            return Double.POSITIVE_INFINITY;
        }

        public double getHeight() {
            return Double.POSITIVE_INFINITY;
        }

        public double getCenterX() {
            return Double.NaN;
        }

        public double getCenterY() {
            return Double.NaN;
        }

        public void add(Rectangle2D rect) {
        }

        public void add(Point2D point) {
        }

        public void add(double x, double y) {
        }

        public int outcode(double x, double y) {
            return 0;
        }

        public int outcode(Point2D point) {
            return 0;
        }

        public boolean contains(Point2D point) {
            return true;
        }

        public boolean contains(Rectangle2D rect) {
            return true;
        }

        public boolean contains(double x, double y) {
            return true;
        }

        public boolean contains(double x, double y, double w, double h) {
            return true;
        }

        public boolean intersects(Rectangle2D rect) {
            return true;
        }

        public boolean intersects(double x, double y, double w, double h) {
            return true;
        }

        public boolean intersectsLine(double x, double y, double u, double v) {
            return true;
        }

        public boolean intersectsLine(Line2D line) {
            return true;
        }

        public boolean isEmpty() {
            return false;
        }

        public Rectangle2D getFrame() {
            return this;
        }

        public Rectangle2D getBounds2D() {
            return this;
        }

        public Rectangle2D createUnion(Rectangle2D rect) {
            return this;
        }

        public Rectangle2D createIntersection(Rectangle2D rect) {
            return (Rectangle2D)rect.clone();
        }

        public void setRect(double x, double y, double w, double h) {
            throw new UnsupportedOperationException();
        }

        private Object readResolve() throws ObjectStreamException {
            return INFINITY;
        }
    }
}

