/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import org.geotools.resources.image.MultiBandsIndexColorModel;

public final class ColorUtilities {
    private static final double EPS = 1.0E-6;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ColorUtilities() {
    }

    public static Color[] subarray(Color[] palette, int lower, int upper) {
        if (palette != null) {
            if ((lower = Math.max(lower, 0)) >= (upper = Math.min(upper, palette.length))) {
                return null;
            }
            if (lower != 0 || upper != palette.length) {
                Color[] sub = new Color[upper - lower];
                System.arraycopy(palette, lower, sub, 0, sub.length);
                return sub;
            }
        }
        return palette;
    }

    public static void expand(Color[] colors, int[] ARGB, int lower, int upper) {
        switch (colors.length) {
            case 1: {
                Arrays.fill(ARGB, lower, upper, colors[0].getRGB());
            }
            case 0: {
                return;
            }
        }
        switch (upper - lower) {
            case 1: {
                ARGB[lower] = colors[0].getRGB();
            }
            case 0: {
                return;
            }
        }
        int maxBase = colors.length - 2;
        double scale = (double)(colors.length - 1) / (double)(upper - 1 - lower);
        for (int i = lower; i < upper; ++i) {
            double index = (double)(i - lower) * scale;
            int base = Math.min(maxBase, (int)(index + 1.0E-6));
            double delta = index - (double)base;
            Color C0 = colors[base + 0];
            Color C1 = colors[base + 1];
            int A = C0.getAlpha();
            int R = C0.getRed();
            int G = C0.getGreen();
            int B = C0.getBlue();
            ARGB[i] = ColorUtilities.round((double)A + delta * (double)(C1.getAlpha() - A)) << 24 | ColorUtilities.round((double)R + delta * (double)(C1.getRed() - R)) << 16 | ColorUtilities.round((double)G + delta * (double)(C1.getGreen() - G)) << 8 | ColorUtilities.round((double)B + delta * (double)(C1.getBlue() - B)) << 0;
        }
    }

    private static int round(double value) {
        return Math.min(Math.max((int)Math.round(value), 0), 255);
    }

    public static IndexColorModel getIndexColorModel(int[] ARGB) {
        return ColorUtilities.getIndexColorModel(ARGB, 1, 0);
    }

    public static IndexColorModel getIndexColorModel(int[] ARGB, int numBands, int visibleBand) {
        boolean hasAlpha = false;
        int transparent = -1;
        for (int i = 0; i < ARGB.length; ++i) {
            int alpha = ARGB[i] & 0xFF000000;
            if (alpha == -16777216) continue;
            if (alpha == 0 && transparent < 0) {
                transparent = i;
                continue;
            }
            hasAlpha = true;
            break;
        }
        int bits = ColorUtilities.getBitCount(ARGB.length);
        int type = ColorUtilities.getTransferType(ARGB.length);
        if (numBands == 1) {
            return new IndexColorModel(bits, ARGB.length, ARGB, 0, hasAlpha, transparent, type);
        }
        return new MultiBandsIndexColorModel(bits, ARGB.length, ARGB, 0, hasAlpha, transparent, type, numBands, visibleBand);
    }

    public static int getBitCount(int mapSize) {
        if (mapSize <= 2) {
            return 1;
        }
        if (mapSize <= 4) {
            return 2;
        }
        if (mapSize <= 16) {
            return 4;
        }
        if (mapSize <= 256) {
            return 8;
        }
        if (mapSize <= 65536) {
            return 16;
        }
        throw new IllegalArgumentException(Integer.toString(mapSize));
    }

    private static int getTransferType(int mapSize) {
        return mapSize <= 256 ? 0 : 1;
    }

    private static float[] XYZtoLAB(float[] color) {
        color[0] = (float)((double)color[0] / 0.9642);
        color[1] = (float)((double)color[1] / 1.0);
        color[2] = (float)((double)color[2] / 0.8249);
        for (int i = 0; i < 3; ++i) {
            float c = color[i];
            color[i] = (float)(c > 0.008856452f ? Math.pow(c, 0.3333333333333333) : (903.2962962962963 * (double)c + 16.0) / 116.0);
        }
        float L = 116.0f * color[1] - 16.0f;
        float a = 500.0f * (color[0] - color[1]);
        float b = 200.0f * (color[1] - color[2]);
        if (!$assertionsDisabled && (Float.isNaN(L) || Float.isNaN(a) || Float.isNaN(b))) {
            throw new AssertionError();
        }
        color[0] = L;
        color[1] = a;
        color[2] = b;
        return color;
    }

    private static float colorDistance(float[] lab1, float[] lab2) {
        double sum = 0.0;
        int i = Math.min(lab1.length, lab2.length);
        while (--i >= 0) {
            double delta = lab1[i] - lab2[i];
            sum += delta * delta;
        }
        return (float)Math.sqrt(sum);
    }

    public static int getTransparentPixel(IndexColorModel colors) {
        int index = colors.getTransparentPixel();
        if (index < 0) {
            index = 0;
            int alpha = Integer.MAX_VALUE;
            float delta = Float.POSITIVE_INFINITY;
            ColorSpace space = colors.getColorSpace();
            float[] RGB = new float[3];
            float[] BLACK = ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB));
            if (!$assertionsDisabled && BLACK == RGB) {
                throw new AssertionError();
            }
            int i = colors.getMapSize();
            while (--i >= 0) {
                int a = colors.getAlpha(i);
                if (a > alpha) continue;
                RGB[0] = (float)colors.getRed(i) / 255.0f;
                RGB[1] = (float)colors.getGreen(i) / 255.0f;
                RGB[2] = (float)colors.getBlue(i) / 255.0f;
                float d = ColorUtilities.colorDistance(ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB)), BLACK);
                if (!$assertionsDisabled && !(d >= 0.0f)) {
                    throw new AssertionError(i);
                }
                if (a >= alpha && !(d < delta)) continue;
                alpha = a;
                delta = d;
                index = i;
            }
        }
        return index;
    }

    public static int getColorIndex(IndexColorModel colors, Color color, int exclude) {
        ColorSpace space = colors.getColorSpace();
        float[] RGB = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        float[] REF = ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB));
        float delta = Float.POSITIVE_INFINITY;
        int index = 0;
        if (!$assertionsDisabled && REF == RGB) {
            throw new AssertionError();
        }
        int i = colors.getMapSize();
        while (--i >= 0) {
            if (i == exclude) continue;
            RGB[0] = (float)colors.getRed(i) / 255.0f;
            RGB[1] = (float)colors.getGreen(i) / 255.0f;
            RGB[2] = (float)colors.getBlue(i) / 255.0f;
            float d = ColorUtilities.colorDistance(ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB)), REF);
            if (!$assertionsDisabled && !(d >= 0.0f)) {
                throw new AssertionError(i);
            }
            if (!(d <= delta)) continue;
            delta = d;
            index = i;
        }
        return index;
    }

    static {
        $assertionsDisabled = !ColorUtilities.class.desiredAssertionStatus();
    }
}

