/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.image;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.registry.RIFRegistry;
import org.geotools.resources.Utilities;
import org.geotools.resources.gcs.Resources;

public final class ImageUtilities {
    private static final Dimension DEFAULT_TILE_SIZE = new Dimension(512, 512);
    private static final int MIN_TILE_SIZE = 128;

    private ImageUtilities() {
    }

    public static ImageLayout getImageLayout(RenderedImage image) {
        return ImageUtilities.getImageLayout(image, true);
    }

    private static ImageLayout getImageLayout(RenderedImage image, boolean initToImage) {
        ImageLayout layout;
        if (image == null) {
            return null;
        }
        ImageLayout imageLayout = layout = initToImage ? new ImageLayout(image) : null;
        if (image.getNumXTiles() == 1 && image.getNumYTiles() == 1) {
            int s;
            Dimension defaultSize;
            if (layout != null) {
                layout = layout.unsetTileLayout();
            }
            if ((defaultSize = JAI.getDefaultTileSize()) == null) {
                defaultSize = DEFAULT_TILE_SIZE;
            }
            if ((s = ImageUtilities.toTileSize(image.getWidth(), defaultSize.width)) != 0) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                layout = layout.setTileWidth(s);
            }
            if ((s = ImageUtilities.toTileSize(image.getHeight(), defaultSize.height)) != 0) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                layout = layout.setTileHeight(s);
            }
        }
        return layout;
    }

    public static RenderingHints getRenderingHints(RenderedImage image) {
        ImageLayout layout = ImageUtilities.getImageLayout(image, false);
        return layout != null ? new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout) : null;
    }

    public static Dimension toTileSize(Dimension size) {
        int s;
        Dimension defaultSize = JAI.getDefaultTileSize();
        if (defaultSize == null) {
            defaultSize = DEFAULT_TILE_SIZE;
        }
        if ((s = ImageUtilities.toTileSize(size.width, defaultSize.width)) != 0) {
            size.width = s;
        }
        if ((s = ImageUtilities.toTileSize(size.height, defaultSize.height)) != 0) {
            size.height = s;
        }
        return size;
    }

    private static int toTileSize(int imageSize, int tileSize) {
        int sopt = 0;
        int rmax = 0;
        int MAX_TILE_SIZE = Math.min(tileSize * 2, imageSize);
        int stop = Math.max(tileSize - 128, MAX_TILE_SIZE - tileSize);
        for (int i = 0; i <= stop; ++i) {
            int r;
            int s = tileSize - i;
            if (s >= 128) {
                r = imageSize % s;
                if (r == 0) {
                    return s;
                }
                if (r > rmax) {
                    rmax = r;
                    sopt = s;
                }
            }
            if ((s = tileSize + i) > MAX_TILE_SIZE) continue;
            r = imageSize % s;
            if (r == 0) {
                return s;
            }
            if (r <= rmax) continue;
            rmax = r;
            sopt = s;
        }
        return tileSize - rmax <= tileSize / 4 ? sopt : 0;
    }

    public static ImageLayout createIntersection(ImageLayout layout, List sources) {
        int n;
        ImageLayout result = layout;
        if (result == null) {
            result = new ImageLayout();
        }
        if ((n = sources.size()) != 0) {
            RenderedImage source = (RenderedImage)sources.get(0);
            int minXL = result.getMinX(source);
            int minYL = result.getMinY(source);
            int maxXL = result.getWidth(source) + minXL;
            int maxYL = result.getHeight(source) + minYL;
            for (int i = 0; i < n; ++i) {
                source = (RenderedImage)sources.get(i);
                int minX = source.getMinX();
                int minY = source.getMinY();
                int maxX = source.getWidth() + minX;
                int maxY = source.getHeight() + minY;
                int mask = 0;
                if (minXL < minX) {
                    mask |= 5;
                }
                if (minYL < minY) {
                    mask |= 0xA;
                }
                if (maxXL > maxX) {
                    mask |= 4;
                }
                if (maxYL > maxY) {
                    mask |= 8;
                }
                if (mask == 0) continue;
                if (layout == result) {
                    result = (ImageLayout)layout.clone();
                }
                if ((mask & 1) != 0) {
                    minXL = minX;
                    result.setMinX(minXL);
                }
                if ((mask & 2) != 0) {
                    minYL = minY;
                    result.setMinY(minYL);
                }
                if ((mask & 4) != 0) {
                    maxXL = maxX;
                    result.setWidth(maxXL - minXL);
                }
                if ((mask & 8) == 0) continue;
                maxYL = maxY;
                result.setHeight(maxYL - minYL);
            }
            if (result != layout) {
                int newSize;
                int oldSize;
                source = (RenderedImage)sources.get(0);
                if (result.isValid(64) && (oldSize = result.getTileWidth(source)) != (newSize = ImageUtilities.toTileSize(result.getWidth(source), oldSize))) {
                    result.setTileWidth(newSize);
                }
                if (result.isValid(128) && (oldSize = result.getTileHeight(source)) != (newSize = ImageUtilities.toTileSize(result.getHeight(source), oldSize))) {
                    result.setTileHeight(newSize);
                }
            }
        }
        return result;
    }

    public static synchronized void allowNativeAcceleration(String operation, boolean allowed) {
        String product = "com.sun.media.jai";
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        List factories = registry.getOrderedFactoryList("rendered", operation, "com.sun.media.jai");
        if (factories != null) {
            RenderedImageFactory javaFactory = null;
            RenderedImageFactory nativeFactory = null;
            Boolean currentState = null;
            Iterator it = factories.iterator();
            while (it.hasNext()) {
                RenderedImageFactory factory = (RenderedImageFactory)it.next();
                String pack = factory.getClass().getPackage().getName();
                if (pack.equals("com.sun.media.jai.mlib")) {
                    nativeFactory = factory;
                    if (javaFactory != null) {
                        currentState = Boolean.FALSE;
                    }
                }
                if (!pack.equals("com.sun.media.jai.opimage")) continue;
                javaFactory = factory;
                if (nativeFactory == null) continue;
                currentState = Boolean.TRUE;
            }
            if (currentState != null && currentState != allowed) {
                RIFRegistry.unsetPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? javaFactory : nativeFactory), (RenderedImageFactory)(allowed ? nativeFactory : javaFactory));
                RIFRegistry.setPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? nativeFactory : javaFactory), (RenderedImageFactory)(allowed ? javaFactory : nativeFactory));
                LogRecord record = Resources.getResources(null).getLogRecord(Level.CONFIG, 81, operation, new Integer(allowed ? 1 : 0));
                record.setSourceClassName("ImageUtilities");
                record.setSourceMethodName("allowNativeAcceleration");
                Logger.getLogger("org.geotools.gp").log(record);
            }
        }
    }

    public static synchronized void allowNativeCodec(String format, boolean writer, boolean allowed) {
        ImageReaderWriterSpi standard = null;
        ImageReaderWriterSpi codeclib = null;
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Class clazz = writer ? ImageWriterSpi.class : ImageReaderSpi.class;
        Class category = clazz;
        Iterator it = registry.getServiceProviders(category, false);
        block0: while (it.hasNext()) {
            ImageReaderWriterSpi provider = (ImageReaderWriterSpi)it.next();
            String[] formats = provider.getFormatNames();
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equalsIgnoreCase(format)) continue;
                if (Utilities.getShortClassName(provider).startsWith("CLib")) {
                    codeclib = provider;
                    continue block0;
                }
                standard = provider;
                continue block0;
            }
        }
        if (standard != null && codeclib != null) {
            if (allowed) {
                registry.setOrdering(category, codeclib, standard);
            } else {
                registry.setOrdering(category, standard, codeclib);
            }
        }
    }
}

