/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.image;

import java.util.NoSuchElementException;
import javax.media.jai.IntegerSequence;
import org.geotools.resources.XArray;

public final class JAIUtilities {
    private JAIUtilities() {
    }

    public static void fill(IntegerSequence sequence, int lower, int upper) {
        if (sequence != null) {
            while (lower < upper) {
                sequence.insert(lower++);
            }
        }
    }

    public static void add(IntegerSequence sequence, IntegerSequence toAdd, int offset) {
        if (sequence != null) {
            toAdd.startEnumeration();
            while (toAdd.hasMoreElements()) {
                sequence.insert(toAdd.nextElement() + offset);
            }
        }
    }

    public static int getMinimum(IntegerSequence sequence) throws NoSuchElementException {
        sequence.startEnumeration();
        return sequence.nextElement();
    }

    public static int getMaximum(IntegerSequence sequence) throws NoSuchElementException {
        int n;
        sequence.startEnumeration();
        do {
            n = sequence.nextElement();
        } while (sequence.hasMoreElements());
        return n;
    }

    public static boolean contains(IntegerSequence sequence, int value) {
        sequence.startEnumeration();
        while (sequence.hasMoreElements()) {
            if (sequence.nextElement() != value) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(IntegerSequence sequence, int lower, int upper) {
        sequence.startEnumeration();
        while (sequence.hasMoreElements()) {
            int n = sequence.nextElement();
            if (n < lower) continue;
            if (n != lower) break;
            if (++lower != upper) continue;
            return true;
        }
        return lower >= upper;
    }

    public static boolean containsAny(IntegerSequence sequence, int lower, int upper) {
        if (upper <= lower) {
            return true;
        }
        sequence.startEnumeration();
        while (sequence.hasMoreElements()) {
            int n = sequence.nextElement();
            if (n < lower || n >= upper) continue;
            return true;
        }
        return false;
    }

    public static int[] toArray(IntegerSequence sequence) {
        int[] array = new int[sequence.getNumElements()];
        int i = 0;
        sequence.startEnumeration();
        while (sequence.hasMoreElements()) {
            array[i++] = sequence.nextElement();
        }
        return XArray.resize(array, i);
    }

    public static IntegerSequence createSequence(int min, int max) {
        IntegerSequence sequence = new IntegerSequence(min, max);
        while (min <= max) {
            sequence.insert(min++);
        }
        return sequence;
    }
}

